/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.util;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public final class FileConfigUtil {
    public static final String CLASSPATH_FILE_FLAG = "classpath:";

    public static Properties loadProperties(String fileName) {
        if (StringUtil.isNotBlank(fileName)) {
            if (fileName.startsWith(CLASSPATH_FILE_FLAG)) {
                return FileConfigUtil.loadPropertiesFromClasspathFile(fileName);
            }
            return FileConfigUtil.loadPropertiesFromAbsoluteFile(fileName);
        }
        return null;
    }

    private static Properties loadPropertiesFromAbsoluteFile(String fileName) {
        Properties properties = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(fileName, new String[0]), Charset.forName(SentinelConfig.charset()));){
                properties = new Properties();
                properties.load(bufferedReader);
            }
        }
        catch (Throwable e) {
            RecordLog.warn("Error when loading properties from: {0}", fileName, e);
            e.printStackTrace();
        }
        return properties;
    }

    private static boolean absolutePathStart(String path) {
        File[] files;
        for (File file : files = File.listRoots()) {
            if (!path.startsWith(file.getPath())) continue;
            return true;
        }
        return false;
    }

    private static Properties loadPropertiesFromClasspathFile(String fileName) {
        fileName = fileName.substring(CLASSPATH_FILE_FLAG.length()).trim();
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = FileConfigUtil.getClassLoader().getResources(fileName);
            list = new ArrayList();
            while (urls.hasMoreElements()) {
                list.add(urls.nextElement());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (list.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        for (URL url : list) {
            Properties p = new Properties();
            try {
                InputStreamReader reader = new InputStreamReader(url.openStream(), Charset.forName(SentinelConfig.charset()).newDecoder());
                Throwable throwable = null;
                try {
                    p.load(reader);
                    properties.putAll((Map<?, ?>)p);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Throwable e) {
                RecordLog.warn("Error when loading properties from: {0}", url.toString(), e);
                e.printStackTrace();
            }
        }
        return properties;
    }

    private static Properties loadPropertiesFromRelativeFile(String fileName) {
        String userDir = System.getProperty("user.dir");
        String realFilePath = FileConfigUtil.addSeparator(userDir) + fileName;
        return FileConfigUtil.loadPropertiesFromAbsoluteFile(realFilePath);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = FileConfigUtil.class.getClassLoader();
        }
        return classLoader;
    }

    public static String addSeparator(String dir) {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir;
    }

    private FileConfigUtil() {
    }
}

