/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.cluster;

import com.alibaba.csp.ahas.sentinel.cluster.entity.ClusterGroupEntity;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.List;

public class ClusterServerTransportConfigParser
implements Converter<String, ServerTransportConfig> {
    @Override
    public ServerTransportConfig convert(String source) {
        if (source == null) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        RecordLog.info("[ClusterServerTransportConfigParser] Get data: " + data, new Object[0]);
        List<ClusterGroupEntity> groupList = JSON.parseObject(data, new TypeReference<List<ClusterGroupEntity>>(){}, new Feature[0]);
        if (groupList == null || groupList.isEmpty()) {
            return null;
        }
        return this.extractServerTransportConfig(groupList);
    }

    private ServerTransportConfig extractServerTransportConfig(List<ClusterGroupEntity> groupList) {
        for (ClusterGroupEntity group : groupList) {
            if (!MachineUtils.isCurrentMachineEqual(group)) continue;
            return new ServerTransportConfig().setPort(group.getServerPort()).setIdleSeconds(600);
        }
        return null;
    }
}

