/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.cluster;

import com.alibaba.csp.ahas.sentinel.cluster.entity.ClusterGroupEntity;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.List;

public class ClusterAssignStateParser
implements Converter<String, Integer> {
    @Override
    public Integer convert(String source) {
        if (source == null) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        RecordLog.info("[ClusterAssignStateParser] Get data: " + data, new Object[0]);
        List<ClusterGroupEntity> groupList = JSON.parseObject(data, new TypeReference<List<ClusterGroupEntity>>(){}, new Feature[0]);
        if (groupList == null || groupList.isEmpty()) {
            return -1;
        }
        return this.extractMode(groupList);
    }

    private int extractMode(List<ClusterGroupEntity> groupList) {
        for (ClusterGroupEntity group : groupList) {
            if (MachineUtils.isCurrentMachineEqual(group)) {
                return 1;
            }
            if (group.getClientSet() == null) continue;
            for (String client : group.getClientSet()) {
                if (client == null || !client.equals(MachineUtils.getCurrentProcessConfigurationId())) continue;
                return 0;
            }
        }
        return -1;
    }
}

