/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.ahas.sentinel.AhasGlobalContext;
import com.alibaba.csp.ahas.sentinel.SentinelAcmDataSourceService;
import com.alibaba.csp.ahas.sentinel.SentinelRequestHandler;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.transport.TransportService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.DefaultClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.SentinelDisabledException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat.DefaultHeartbeatService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat.HeartbeatService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.init.AhasInitFunc;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.transport.DefaultTransportService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.ServiceConstants;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.support.LogLog;
import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.cluster.server.command.handler.FetchClusterServerInfoCommandHandler;
import com.alibaba.csp.sentinel.cluster.server.command.handler.ModifyClusterServerFlowConfigHandler;
import com.alibaba.csp.sentinel.cluster.server.command.handler.ModifyServerNamespaceSetHandler;
import com.alibaba.csp.sentinel.command.handler.FetchActiveRuleCommandHandler;
import com.alibaba.csp.sentinel.command.handler.FetchClusterClientConfigHandler;
import com.alibaba.csp.sentinel.command.handler.FetchJsonTreeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.FetchSimpleClusterNodeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.ModifyClusterClientConfigHandler;
import com.alibaba.csp.sentinel.command.handler.OnOffGetCommandHandler;
import com.alibaba.csp.sentinel.command.handler.OnOffSetCommandHandler;
import com.alibaba.csp.sentinel.command.handler.SendMetricCommandHandler;
import com.alibaba.csp.sentinel.command.handler.VersionCommandHandler;
import com.alibaba.csp.sentinel.command.handler.cluster.FetchClusterModeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.cluster.ModifyClusterModeCommandHandler;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

@SpiOrder(value=-10000)
@InitOrder(value=-2147483648)
public class DefaultSentinelSdkService
implements InitFunc,
HeartbeatSender {
    public static final String SENTINEL_ENV_CLASS = "com.alibaba.csp.sentinel.Env";
    private static final ClientInfoService clientInfoService = new DefaultClientInfoService();
    private static final TransportService transportService = new DefaultTransportService();
    private static final HeartbeatService heartbeatService = new DefaultHeartbeatService();
    private static final AtomicBoolean isAhasInit = new AtomicBoolean(false);
    private static final AtomicBoolean isCommandHandlerRegistered = new AtomicBoolean(false);
    private static final AtomicBoolean ahasInitSuccess = new AtomicBoolean(false);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("DefaultSentinelSdkService-thread"));
    private static DefaultSentinelSdkService defaultSentinelSdkService;

    public static synchronized DefaultSentinelSdkService getInstance() {
        if (defaultSentinelSdkService == null) {
            defaultSentinelSdkService = new DefaultSentinelSdkService();
        }
        return defaultSentinelSdkService;
    }

    public DefaultSentinelSdkService() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!isCommandHandlerRegistered.compareAndSet(false, true)) {
                        DefaultSentinelSdkService.this.registerCommandHandler();
                    }
                }
                catch (Throwable e) {
                    RecordLog.info("[DefaultSentinelSdkService] registerCommandHandler error", e);
                }
                try {
                    DefaultSentinelSdkService.this.initAhas();
                    ahasInitSuccess.set(true);
                    RecordLog.info("set initSuccess Flag to true", new Object[0]);
                }
                catch (Throwable e) {
                    RecordLog.warn("[DefaultSentinelSdkService] init ahas error", e);
                    System.err.println("ERROR: AHAS init fail");
                }
            }
        };
        executor.submit(runnable);
    }

    @Override
    public void init() throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!ahasInitSuccess.get()) {
                    return;
                }
                try {
                    LogLog.setQuietMode(true);
                    MachineUtils.setCurrentProcessConfigurationId(clientInfoService.getAid());
                    SentinelAcmDataSourceService acmDataSourceService = new SentinelAcmDataSourceService(clientInfoService);
                    acmDataSourceService.initAcmDataSource();
                    DefaultSentinelSdkService.this.initSentinel();
                }
                catch (Throwable throwable) {
                    RecordLog.warn("[DefaultSentinelSdkService] init acm error", throwable);
                }
            }
        };
        executor.submit(runnable);
    }

    private void initAhas() throws Exception {
        if (!isAhasInit.compareAndSet(false, true)) {
            return;
        }
        System.setProperty("ahas.version", this.getWholeVersion("1.4.5"));
        int times = 0;
        while (true) {
            try {
                ((AhasInitFunc)((Object)clientInfoService)).init("JAVA_SDK", null);
                transportService.init(clientInfoService);
                heartbeatService.init(clientInfoService, transportService);
            }
            catch (Throwable throwable) {
                if (throwable instanceof SentinelDisabledException) {
                    RecordLog.info("[DefaultSentinelSdkService] sentinel disabled, stop connect to server.", new Object[0]);
                    throw new SentinelDisabledException("sentinel disabled.");
                }
                RecordLog.info("[DefaultSentinelSdkService] init ahas fail, will retry " + times, throwable);
                ++times;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        RecordLog.info("[DefaultSentinelSdkService] AHAS gateway host: " + clientInfoService.getGatewayHost() + "port:" + clientInfoService.getGatewayPort(), new Object[0]);
        RecordLog.info("[DefaultSentinelSdkService] Really init AHAS", new Object[0]);
        AhasGlobalContext.setClientInfoService(clientInfoService);
    }

    private String getWholeVersion(String defaultGwVersion) {
        String coreVersion = Constants.SENTINEL_VERSION;
        String gwVersion = defaultGwVersion;
        try {
            String version = DefaultSentinelSdkService.class.getPackage().getImplementationVersion();
            if (StringUtil.isNotBlank(version)) {
                gwVersion = version;
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[DefaultSentinelSdkService] Using default version, ignore exception", e);
        }
        String wholeVersion = coreVersion + "_" + gwVersion;
        RecordLog.info("[DefaultSentinelSdkService] wholeVersion: " + wholeVersion, new Object[0]);
        return wholeVersion;
    }

    private void initSentinel() throws Exception {
        try {
            this.getClass().getClassLoader().loadClass(SENTINEL_ENV_CLASS);
        }
        catch (ClassNotFoundException e) {
            RecordLog.warn("[DefaultSentinelSdkService][ERROR] com.alibaba.csp.sentinel.Env not found!", e);
        }
    }

    private void registerCommandHandler() {
        transportService.registerHandler(ServiceConstants.Sentinel.CLUSTER_NODE.getHandlerName(), new SentinelRequestHandler<String>(new FetchSimpleClusterNodeCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.JSON_TREE.getHandlerName(), new SentinelRequestHandler<String>(new FetchJsonTreeCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.METRIC.getHandlerName(), new SentinelRequestHandler<String>(new SendMetricCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_RULES.getHandlerName(), new SentinelRequestHandler<String>(new FetchActiveRuleCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.VERSION.getHandlerName(), new SentinelRequestHandler<String>(new VersionCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_SWITCH.getHandlerName(), new SentinelRequestHandler<String>(new OnOffGetCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.SET_SWITCH.getHandlerName(), new SentinelRequestHandler<String>(new OnOffSetCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.SET_CLUSTER_MODE.getHandlerName(), new SentinelRequestHandler<String>(new ModifyClusterModeCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_CLUSTER_MODE.getHandlerName(), new SentinelRequestHandler<String>(new FetchClusterModeCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_CLUSTER_CLIENT_INFO.getHandlerName(), new SentinelRequestHandler<String>(new FetchClusterClientConfigHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.MODIFY_CLUSTER_CLIENT_CONFIG.getHandlerName(), new SentinelRequestHandler<String>(new ModifyClusterClientConfigHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_CLUSTER_SERVER_INFO.getHandlerName(), new SentinelRequestHandler<String>(new FetchClusterServerInfoCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.MODIFY_CLUSTER_SERVER_FLOW_CONFIG.getHandlerName(), new SentinelRequestHandler<String>(new ModifyClusterServerFlowConfigHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.MODIFY_CLUSTER_SERVER_NAMESPACE_SET.getHandlerName(), new SentinelRequestHandler<String>(new ModifyServerNamespaceSetHandler()));
    }

    @Override
    public boolean sendHeartbeat() throws Exception {
        if (!ahasInitSuccess.get() || clientInfoService.getSentinalDisable() == 1) {
            return false;
        }
        Response<String> mapResponse = heartbeatService.sendHeartbeat();
        if (!mapResponse.isSuccess()) {
            throw new RuntimeException(mapResponse.toString());
        }
        return mapResponse.isSuccess();
    }

    @Override
    public long intervalMs() {
        return 5000L;
    }
}

