/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.ipfilter;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.ipfilter.CIDR;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.ipfilter.CIDR4;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.logging.InternalLogger;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CIDR6
extends CIDR {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CIDR6.class);
    private BigInteger addressBigInt;
    private final BigInteger addressEndBigInt;

    protected CIDR6(Inet6Address newaddress, int newmask) {
        this.cidrMask = newmask;
        this.addressBigInt = CIDR6.ipv6AddressToBigInteger(newaddress);
        BigInteger mask = CIDR6.ipv6CidrMaskToMask(newmask);
        try {
            this.addressBigInt = this.addressBigInt.and(mask);
            this.baseAddress = CIDR6.bigIntToIPv6Address(this.addressBigInt);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.addressEndBigInt = this.addressBigInt.add(CIDR6.ipv6CidrMaskToBaseAddress(this.cidrMask)).subtract(BigInteger.ONE);
    }

    public InetAddress getEndAddress() {
        try {
            return CIDR6.bigIntToIPv6Address(this.addressEndBigInt);
        }
        catch (UnknownHostException e) {
            if (logger.isErrorEnabled()) {
                logger.error("invalid ip address calculated as an end address");
            }
            return null;
        }
    }

    public int compareTo(CIDR arg) {
        if (arg instanceof CIDR4) {
            BigInteger net = CIDR6.ipv6AddressToBigInteger(arg.baseAddress);
            int res = net.compareTo(this.addressBigInt);
            if (res == 0) {
                if (arg.cidrMask == this.cidrMask) {
                    return 0;
                }
                if (arg.cidrMask < this.cidrMask) {
                    return -1;
                }
                return 1;
            }
            return res;
        }
        CIDR6 o = (CIDR6)arg;
        if (o.addressBigInt.equals(this.addressBigInt) && o.cidrMask == this.cidrMask) {
            return 0;
        }
        int res = o.addressBigInt.compareTo(this.addressBigInt);
        if (res == 0) {
            if (o.cidrMask < this.cidrMask) {
                return -1;
            }
            return 1;
        }
        return res;
    }

    public boolean contains(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("inetAddress");
        }
        if (this.cidrMask == 0) {
            return true;
        }
        BigInteger search = CIDR6.ipv6AddressToBigInteger(inetAddress);
        return search.compareTo(this.addressBigInt) >= 0 && search.compareTo(this.addressEndBigInt) <= 0;
    }

    private static BigInteger ipv6CidrMaskToBaseAddress(int cidrMask) {
        return BigInteger.ONE.shiftLeft(128 - cidrMask);
    }

    private static BigInteger ipv6CidrMaskToMask(int cidrMask) {
        return BigInteger.ONE.shiftLeft(128 - cidrMask).subtract(BigInteger.ONE).not();
    }

    private static BigInteger ipv6AddressToBigInteger(InetAddress addr) {
        byte[] ipv6 = addr instanceof Inet4Address ? CIDR6.getIpV6FromIpV4((Inet4Address)addr) : addr.getAddress();
        if (ipv6[0] == -1) {
            return new BigInteger(1, ipv6);
        }
        return new BigInteger(ipv6);
    }

    private static InetAddress bigIntToIPv6Address(BigInteger addr) throws UnknownHostException {
        byte[] a = new byte[16];
        byte[] b = addr.toByteArray();
        if (b.length > 16 && (b.length != 17 || b[0] != 0)) {
            throw new UnknownHostException("invalid IPv6 address (too big)");
        }
        if (b.length == 16) {
            return InetAddress.getByAddress(b);
        }
        if (b.length == 17) {
            System.arraycopy(b, 1, a, 0, 16);
        } else {
            int p = 16 - b.length;
            System.arraycopy(b, 0, a, p, b.length);
        }
        return InetAddress.getByAddress(a);
    }
}

