/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.spdy;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockRawDecoder;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.spdy.SpdyProtocolException;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.spdy.SpdyVersion;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class SpdyHeaderBlockZlibDecoder
extends SpdyHeaderBlockRawDecoder {
    private static final int DEFAULT_BUFFER_CAPACITY = 4096;
    private static final SpdyProtocolException INVALID_HEADER_BLOCK = new SpdyProtocolException("Invalid Header Block");
    private final Inflater decompressor = new Inflater();
    private ChannelBuffer decompressed;

    SpdyHeaderBlockZlibDecoder(SpdyVersion spdyVersion, int maxHeaderSize) {
        super(spdyVersion, maxHeaderSize);
    }

    void decode(ChannelBuffer headerBlock, SpdyHeadersFrame frame) throws Exception {
        int numBytes;
        if (headerBlock == null) {
            throw new NullPointerException("headerBlock");
        }
        if (frame == null) {
            throw new NullPointerException("frame");
        }
        int len = this.setInput(headerBlock);
        while ((numBytes = this.decompress(frame)) > 0) {
        }
        if (this.decompressor.getRemaining() != 0) {
            throw INVALID_HEADER_BLOCK;
        }
        headerBlock.skipBytes(len);
    }

    private int setInput(ChannelBuffer compressed) {
        int len = compressed.readableBytes();
        if (compressed.hasArray()) {
            this.decompressor.setInput(compressed.array(), compressed.arrayOffset() + compressed.readerIndex(), len);
        } else {
            byte[] in = new byte[len];
            compressed.getBytes(compressed.readerIndex(), in);
            this.decompressor.setInput(in, 0, in.length);
        }
        return len;
    }

    private int decompress(SpdyHeadersFrame frame) throws Exception {
        this.ensureBuffer();
        byte[] out = this.decompressed.array();
        int off = this.decompressed.arrayOffset() + this.decompressed.writerIndex();
        try {
            int numBytes = this.decompressor.inflate(out, off, this.decompressed.writableBytes());
            if (numBytes == 0 && this.decompressor.needsDictionary()) {
                try {
                    this.decompressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
                }
                catch (IllegalArgumentException e) {
                    throw INVALID_HEADER_BLOCK;
                }
                numBytes = this.decompressor.inflate(out, off, this.decompressed.writableBytes());
            }
            this.decompressed.writerIndex(this.decompressed.writerIndex() + numBytes);
            super.decodeHeaderBlock(this.decompressed, frame);
            this.decompressed.discardReadBytes();
            return numBytes;
        }
        catch (DataFormatException e) {
            throw INVALID_HEADER_BLOCK;
        }
    }

    private void ensureBuffer() {
        if (this.decompressed == null) {
            this.decompressed = ChannelBuffers.dynamicBuffer(4096);
        }
        this.decompressed.ensureWritableBytes(1);
    }

    void endHeaderBlock(SpdyHeadersFrame frame) throws Exception {
        super.endHeaderBlock(frame);
        this.decompressed = null;
    }

    public void end() {
        super.end();
        this.decompressed = null;
        this.decompressor.end();
    }
}

