/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.socks;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.socks.SocksMessage;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.socks.SocksResponse;

public final class SocksCmdResponse
extends SocksResponse {
    private final SocksMessage.CmdStatus cmdStatus;
    private final SocksMessage.AddressType addressType;
    private static final byte[] IPv4_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0};
    private static final byte[] IPv6_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public SocksCmdResponse(SocksMessage.CmdStatus cmdStatus, SocksMessage.AddressType addressType) {
        super(SocksResponse.SocksResponseType.CMD);
        if (cmdStatus == null) {
            throw new NullPointerException("cmdStatus");
        }
        if (addressType == null) {
            throw new NullPointerException("addressType");
        }
        this.cmdStatus = cmdStatus;
        this.addressType = addressType;
    }

    public SocksMessage.CmdStatus getCmdStatus() {
        return this.cmdStatus;
    }

    public SocksMessage.AddressType getAddressType() {
        return this.addressType;
    }

    public void encodeAsByteBuf(ChannelBuffer channelBuffer) {
        channelBuffer.writeByte(this.getProtocolVersion().getByteValue());
        channelBuffer.writeByte(this.cmdStatus.getByteValue());
        channelBuffer.writeByte(0);
        channelBuffer.writeByte(this.addressType.getByteValue());
        switch (this.addressType) {
            case IPv4: {
                channelBuffer.writeBytes(IPv4_HOSTNAME_ZEROED);
                channelBuffer.writeShort(0);
                break;
            }
            case DOMAIN: {
                channelBuffer.writeByte(1);
                channelBuffer.writeByte(0);
                channelBuffer.writeShort(0);
                break;
            }
            case IPv6: {
                channelBuffer.writeBytes(IPv6_HOSTNAME_ZEROED);
                channelBuffer.writeShort(0);
            }
        }
    }
}

