/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.websocketx;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.CharsetUtil;
import java.io.UnsupportedEncodingException;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame() {
        this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
    }

    public CloseWebSocketFrame(int statusCode, String reasonText) {
        this(true, 0, statusCode, reasonText);
    }

    public CloseWebSocketFrame(boolean finalFragment, int rsv) {
        this(finalFragment, rsv, null);
    }

    public CloseWebSocketFrame(boolean finalFragment, int rsv, int statusCode, String reasonText) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        byte[] reasonBytes = new byte[]{};
        if (reasonText != null) {
            try {
                reasonBytes = reasonText.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                reasonBytes = reasonText.getBytes();
            }
        }
        ChannelBuffer binaryData = ChannelBuffers.buffer(2 + reasonBytes.length);
        binaryData.writeShort(statusCode);
        if (reasonBytes.length > 0) {
            binaryData.writeBytes(reasonBytes);
        }
        binaryData.readerIndex(0);
        this.setBinaryData(binaryData);
    }

    public CloseWebSocketFrame(boolean finalFragment, int rsv, ChannelBuffer binaryData) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        if (binaryData == null) {
            this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
        } else {
            this.setBinaryData(binaryData);
        }
    }

    public int getStatusCode() {
        ChannelBuffer binaryData = this.getBinaryData();
        if (binaryData == null || binaryData.capacity() == 0) {
            return -1;
        }
        binaryData.readerIndex(0);
        short statusCode = binaryData.readShort();
        binaryData.readerIndex(0);
        return statusCode;
    }

    public String getReasonText() {
        ChannelBuffer binaryData = this.getBinaryData();
        if (binaryData == null || binaryData.capacity() <= 2) {
            return "";
        }
        binaryData.readerIndex(2);
        String reasonText = binaryData.toString(CharsetUtil.UTF_8);
        binaryData.readerIndex(0);
        return reasonText;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

