/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm.endpoint;

import com.alibaba.cloud.acm.AcmProperties;
import com.alibaba.cloud.acm.AcmPropertySourceRepository;
import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import com.taobao.diamond.client.Diamond;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.StringUtils;

public class AcmHealthIndicator
extends AbstractHealthIndicator {
    private final AcmProperties acmProperties;
    private final AcmPropertySourceRepository acmPropertySourceRepository;
    private final List<String> dataIds;

    public AcmHealthIndicator(AcmProperties acmProperties, AcmPropertySourceRepository acmPropertySourceRepository) {
        this.acmProperties = acmProperties;
        this.acmPropertySourceRepository = acmPropertySourceRepository;
        this.dataIds = new ArrayList<String>();
        for (AcmPropertySource acmPropertySource : this.acmPropertySourceRepository.getAll()) {
            this.dataIds.add(acmPropertySource.getDataId());
        }
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        for (String dataId : this.dataIds) {
            try {
                String config = Diamond.getConfig((String)dataId, (String)this.acmProperties.getGroup(), (long)this.acmProperties.getTimeOut());
                if (!StringUtils.isEmpty((Object)config)) continue;
                builder.down().withDetail(String.format("dataId: '%s', group: '%s'", dataId, this.acmProperties.getGroup()), (Object)"config is empty");
            }
            catch (Exception e) {
                builder.down().withDetail(String.format("dataId: '%s', group: '%s'", dataId, this.acmProperties.getGroup()), (Object)e.getMessage());
            }
        }
        builder.up().withDetail("dataIds", this.dataIds);
    }
}

