/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm.endpoint;

import com.alibaba.cloud.acm.AcmProperties;
import com.alibaba.cloud.acm.AcmPropertySourceRepository;
import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import com.alibaba.cloud.acm.refresh.AcmRefreshHistory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;

public class AcmEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private final AcmProperties properties;
    private final AcmRefreshHistory refreshHistory;
    private final AcmPropertySourceRepository propertySourceRepository;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public AcmEndpoint(AcmProperties properties, AcmRefreshHistory refreshHistory, AcmPropertySourceRepository propertySourceRepository) {
        super("acm");
        this.properties = properties;
        this.refreshHistory = refreshHistory;
        this.propertySourceRepository = propertySourceRepository;
    }

    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("config", this.properties);
        HashMap<String, AbstractList> runtime = new HashMap<String, AbstractList>();
        List<AcmPropertySource> all = this.propertySourceRepository.getAll();
        ArrayList sources = new ArrayList();
        for (AcmPropertySource ps : all) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("dataId", ps.getDataId());
            source.put("lastSynced", this.dateFormat.format(ps.getTimestamp()));
            sources.add(source);
        }
        runtime.put("sources", sources);
        runtime.put("refreshHistory", this.refreshHistory.getRecords());
        result.put("runtime", runtime);
        return result;
    }
}

