/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm.bootstrap;

import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import com.alibaba.cloud.acm.bootstrap.AcmPropertySourceBuilder;
import com.alibaba.cloud.acm.diagnostics.analyzer.DiamondConnectionFailureException;
import com.alibaba.edas.acm.ConfigService;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.identify.CredentialService;
import com.taobao.diamond.maintenance.DiamondHealth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class AcmPropertySourceLocator
implements PropertySourceLocator {
    private final Logger logger = LoggerFactory.getLogger(AcmPropertySourceLocator.class);
    private static final String DIAMOND_PROPERTY_SOURCE_NAME = "diamond";
    private static String defaultDiamondGroup = "DEFAULT_GROUP";
    private AcmPropertySourceBuilder acmPropertySourceBuilder = new AcmPropertySourceBuilder();

    public void setAcmPropertySourceBuilder(AcmPropertySourceBuilder acmPropertySourceBuilder) {
        this.acmPropertySourceBuilder = acmPropertySourceBuilder;
    }

    public PropertySource<?> locate(Environment environment) {
        String diamondGroupTmp;
        String secretKey;
        String accessKey;
        String namespace;
        String endpoint = System.getProperty("address.server.domain");
        if (StringUtils.isEmpty((Object)endpoint)) {
            endpoint = environment.getProperty("alibaba.acm.endpoint");
        }
        if (StringUtils.isEmpty((Object)(namespace = TenantUtil.getUserTenant()))) {
            namespace = environment.getProperty("alibaba.acm.namespace");
        }
        if (StringUtils.isEmpty((Object)(accessKey = CredentialService.getInstance().getCredential().getAccessKey()))) {
            accessKey = environment.getProperty("alibaba.acm.accessKey");
        }
        if (StringUtils.isEmpty((Object)(secretKey = CredentialService.getInstance().getCredential().getSecretKey()))) {
            secretKey = environment.getProperty("alibaba.acm.secretKey");
        }
        if ((diamondGroupTmp = environment.getProperty("alibaba.acm.group")) != null) {
            defaultDiamondGroup = diamondGroupTmp;
        }
        try {
            this.logger.info("Initialize ACM on endpoint '" + endpoint + "', namespace '" + namespace + "'.");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initialize ACM with default group '" + defaultDiamondGroup);
                this.logger.debug("Initialize ACM with accessKey '" + accessKey + "', secretKey '" + secretKey + "'.");
            }
            ConfigService.init((String)endpoint, (String)namespace, (String)accessKey, (String)secretKey);
        }
        catch (Throwable t) {
            throw new DiamondConnectionFailureException(ServerHttpAgent.domainName, ServerHttpAgent.addressPort, "ACM environment initialization error", t);
        }
        this.checkDiamondHealth();
        String applicationName = environment.getProperty("spring.application.name");
        this.logger.info("Initialize spring.application.name '" + applicationName + "'.");
        String applicationGroup = environment.getProperty("spring.application.group");
        if (StringUtils.isEmpty((Object)applicationName)) {
            throw new IllegalStateException("'spring.application.name' must be configured.");
        }
        if (StringUtils.isEmpty((Object)applicationGroup)) {
            throw new IllegalStateException("'spring.application.group' must be configured.");
        }
        String[] groupParts = applicationGroup.split("\\.");
        if (groupParts.length < 3) {
            throw new IllegalStateException("spring.application.group '" + applicationGroup + "' must be something like [com].[bu].[product] or [com].[alibaba].[bu].[product], e.g. com.aliexpress.fileserver, com.alibaba.da.coin");
        }
        CompositePropertySource compositePropertySource = new CompositePropertySource(DIAMOND_PROPERTY_SOURCE_NAME);
        this.loadGroupConfigurationRecursively(compositePropertySource, applicationGroup);
        this.loadApplicationConfiguration(compositePropertySource, environment, applicationGroup, applicationName);
        return compositePropertySource;
    }

    private void checkDiamondHealth() {
        this.logger.info("Checking ACM health");
        try {
            if (!DiamondHealth.getHealth().equals("UP")) {
                throw new DiamondConnectionFailureException(ServerHttpAgent.domainName, ServerHttpAgent.addressPort, DiamondHealth.getHealth());
            }
        }
        catch (Throwable t) {
            throw new DiamondConnectionFailureException(ServerHttpAgent.domainName, ServerHttpAgent.addressPort, "ACM Health error", t);
        }
    }

    private void loadGroupConfigurationRecursively(CompositePropertySource compositePropertySource, String applicationGroup) {
        String[] parts = applicationGroup.split("\\.");
        for (int i = 1; i < parts.length; ++i) {
            String subGroup = parts[0];
            for (int j = 1; j <= i; ++j) {
                subGroup = subGroup + "." + parts[j];
            }
            this.loadDiamondDataIfPresent(compositePropertySource, subGroup + ":application.properties", defaultDiamondGroup, true);
        }
    }

    private void loadApplicationConfiguration(CompositePropertySource compositePropertySource, Environment environment, String applicationGroup, String applicationName) {
        this.loadDiamondDataIfPresent(compositePropertySource, applicationGroup + ":" + applicationName + ".properties", defaultDiamondGroup, false);
        for (String profile : environment.getActiveProfiles()) {
            this.loadDiamondDataIfPresent(compositePropertySource, applicationGroup + ":" + applicationName + "-" + profile + ".properties", defaultDiamondGroup, false);
        }
    }

    private void loadDiamondDataIfPresent(CompositePropertySource composite, String dataId, String diamondGroup, boolean groupLevel) {
        AcmPropertySource ps = this.acmPropertySourceBuilder.build(dataId, diamondGroup, groupLevel);
        if (ps != null) {
            composite.addFirstPropertySource((PropertySource)ps);
        }
    }
}

