/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm;

import com.alibaba.cloud.acm.AcmProperties;
import com.alibaba.cloud.acm.AcmPropertySourceRepository;
import com.alibaba.cloud.acm.endpoint.AcmEndpoint;
import com.alibaba.cloud.acm.endpoint.AcmHealthIndicator;
import com.alibaba.cloud.acm.refresh.AcmContextRefresher;
import com.alibaba.cloud.acm.refresh.AcmRefreshHistory;
import com.alibaba.cloud.acm.refresh.AcmRefreshProperties;
import com.taobao.diamond.client.Diamond;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Diamond.class})
@EnableConfigurationProperties(value={AcmProperties.class, AcmRefreshProperties.class})
public class AcmAutoConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final AcmProperties acmProperties;
    private final AcmRefreshProperties acmRefreshProperties;

    @Autowired
    public AcmAutoConfiguration(AcmProperties acmProperties, AcmRefreshProperties acmRefreshProperties) {
        this.acmProperties = acmProperties;
        this.acmRefreshProperties = acmRefreshProperties;
    }

    @Bean
    public AcmPropertySourceRepository acmPropertySourceRepository() {
        return new AcmPropertySourceRepository(this.applicationContext);
    }

    @Bean
    public AcmHealthIndicator acmHealthIndicator(AcmPropertySourceRepository acmPropertySourceRepository) {
        return new AcmHealthIndicator(this.acmProperties, acmPropertySourceRepository);
    }

    @Bean
    public AcmRefreshHistory acmRefreshHistory() {
        return new AcmRefreshHistory();
    }

    @Bean
    public AcmEndpoint acmEndpoint(AcmRefreshHistory acmRefreshHistory, AcmPropertySourceRepository acmPropertySourceRepository) {
        return new AcmEndpoint(this.acmProperties, acmRefreshHistory, acmPropertySourceRepository);
    }

    @Bean
    public AcmContextRefresher acmContextRefresher(ContextRefresher contextRefresher, AcmRefreshHistory refreshHistory, AcmPropertySourceRepository propertySourceRepository) {
        return new AcmContextRefresher(contextRefresher, this.acmProperties, this.acmRefreshProperties, refreshHistory, propertySourceRepository);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

