/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm;

import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;

public class AcmPropertySourceRepository {
    private final ApplicationContext applicationContext;

    public AcmPropertySourceRepository(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List<AcmPropertySource> getAll() {
        ArrayList<AcmPropertySource> result = new ArrayList<AcmPropertySource>();
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)this.applicationContext;
        for (PropertySource p : ctx.getEnvironment().getPropertySources()) {
            if (p instanceof AcmPropertySource) {
                result.add((AcmPropertySource)p);
                continue;
            }
            if (!(p instanceof CompositePropertySource)) continue;
            this.collectDiamondPropertySources((CompositePropertySource)p, result);
        }
        return result;
    }

    private void collectDiamondPropertySources(CompositePropertySource composite, List<AcmPropertySource> result) {
        for (PropertySource p : composite.getPropertySources()) {
            if (p instanceof AcmPropertySource) {
                result.add((AcmPropertySource)p);
                continue;
            }
            if (!(p instanceof CompositePropertySource)) continue;
            this.collectDiamondPropertySources((CompositePropertySource)p, result);
        }
    }
}

