/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.sms;

import com.alibaba.cloud.spring.boot.context.env.AliCloudProperties;
import com.alibaba.cloud.spring.boot.sms.AbstractSmsService;
import com.alibaba.cloud.spring.boot.sms.SmsMessageListener;
import com.alibaba.cloud.spring.boot.sms.SmsReportMessageListener;
import com.alibaba.cloud.spring.boot.sms.SmsUpMessageListener;
import com.alibaba.cloud.spring.boot.sms.actuate.EndpointManager;
import com.alibaba.cloud.spring.boot.sms.actuate.ReceiveMessageEntity;
import com.alibaba.cloud.spring.boot.sms.base.DefaultAlicomMessagePuller;
import com.alibaba.cloud.spring.boot.sms.env.SmsProperties;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendBatchSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendBatchSmsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmsServiceImpl
extends AbstractSmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    private SmsProperties smsProperties;
    private AliCloudProperties aliCloudProperties;

    public SmsServiceImpl(AliCloudProperties aliCloudProperties, SmsProperties smsProperties) {
        this.aliCloudProperties = aliCloudProperties;
        this.smsProperties = smsProperties;
    }

    @Override
    public SendSmsResponse sendSmsRequest(SendSmsRequest sendSmsRequest) throws ClientException {
        return this.sendSmsRequest(sendSmsRequest, this.aliCloudProperties.getAccessKey(), this.aliCloudProperties.getSecretKey());
    }

    @Override
    public SendSmsResponse sendSmsRequest(SendSmsRequest sendSmsRequest, String accessKeyId, String accessKeySecret) throws ServerException, ClientException {
        EndpointManager.addSendSmsRequest(sendSmsRequest);
        return (SendSmsResponse)this.getHangZhouRegionClientProfile(accessKeyId, accessKeySecret).getAcsResponse((AcsRequest)sendSmsRequest);
    }

    @Override
    public boolean startSmsReportMessageListener(SmsReportMessageListener smsReportMessageListener) {
        String messageType = "SmsReport";
        String queueName = this.smsProperties.getReportQueueName();
        return this.startReceiveMsg(messageType, queueName, smsReportMessageListener);
    }

    @Override
    public boolean startSmsUpMessageListener(SmsUpMessageListener smsUpMessageListener) {
        String messageType = "SmsUp";
        String queueName = this.smsProperties.getUpQueueName();
        return this.startReceiveMsg(messageType, queueName, smsUpMessageListener);
    }

    private boolean startReceiveMsg(String messageType, String queueName, SmsMessageListener messageListener) {
        String accessKeyId = this.aliCloudProperties.getAccessKey();
        String accessKeySecret = this.aliCloudProperties.getSecretKey();
        boolean result = true;
        try {
            new DefaultAlicomMessagePuller().startReceiveMsg(accessKeyId, accessKeySecret, messageType, queueName, messageListener);
            EndpointManager.addReceiveMessageEntity(new ReceiveMessageEntity(messageType, queueName, messageListener));
        }
        catch (ClientException e) {
            log.error("start sms report message listener cause an exception", (Throwable)e);
            result = false;
        }
        catch (ParseException e) {
            log.error("start sms report message listener cause an exception", (Throwable)e);
            result = false;
        }
        return result;
    }

    @Override
    public SendBatchSmsResponse sendSmsBatchRequest(SendBatchSmsRequest sendBatchSmsRequest) throws ServerException, ClientException {
        return this.sendSmsBatchRequest(sendBatchSmsRequest, this.aliCloudProperties.getAccessKey(), this.aliCloudProperties.getSecretKey());
    }

    @Override
    public SendBatchSmsResponse sendSmsBatchRequest(SendBatchSmsRequest sendBatchSmsRequest, String accessKeyId, String accessKeySecret) throws ClientException {
        EndpointManager.addSendBatchSmsRequest(sendBatchSmsRequest);
        return (SendBatchSmsResponse)this.getHangZhouRegionClientProfile(accessKeyId, accessKeySecret).getAcsResponse((AcsRequest)sendBatchSmsRequest);
    }

    @Override
    public QuerySendDetailsResponse querySendDetails(QuerySendDetailsRequest request, String accessKeyId, String accessKeySecret) throws ClientException {
        return (QuerySendDetailsResponse)this.getHangZhouRegionClientProfile(accessKeyId, accessKeySecret).getAcsResponse((AcsRequest)request);
    }

    @Override
    public QuerySendDetailsResponse querySendDetails(QuerySendDetailsRequest request) throws ClientException {
        return this.querySendDetails(request, this.aliCloudProperties.getAccessKey(), this.aliCloudProperties.getSecretKey());
    }
}

