/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.githubtoolkit;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.Response;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SearchRepositoryService
implements Function<Request, Response> {
    private static final String SEARCH_REPOS_ENDPOINT = "/search/repositories";
    private static final String DEFAULT_PER_PAGE = "10";
    private static final Logger logger = LoggerFactory.getLogger(SearchRepositoryService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;

    public SearchRepositoryService(WebClientTool webClientTool, JsonParseTool jsonParseTool) {
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
    }

    @Override
    public Response apply(Request request) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"q", (Object)request.query());
        params.add((Object)"per_page", (Object)DEFAULT_PER_PAGE);
        params.add((Object)"sort", (Object)(request.sort() != null ? request.sort() : "best match"));
        params.add((Object)"order", (Object)(request.order() != null ? request.order() : "desc"));
        try {
            String responseData = (String)this.webClientTool.get(SEARCH_REPOS_ENDPOINT, (MultiValueMap)params).block();
            logger.info("SearchRepositoriesOperation success");
            return new Response<List<Repository>>(this.parseRepositorySearchResults(responseData));
        }
        catch (IOException e) {
            logger.error("Error occurred while parsing response: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public List<Repository> parseRepositorySearchResults(String json) throws JsonProcessingException {
        List itemMaps = (List)this.jsonParseTool.getFieldValue(json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, "items");
        return itemMaps.stream().map(itemMap -> {
            long id = ((Number)itemMap.get("id")).longValue();
            String name = (String)itemMap.get("name");
            String fullName = (String)itemMap.get("full_name");
            String description = (String)itemMap.get("description");
            String htmlUrl = (String)itemMap.get("html_url");
            int stargazersCount = ((Number)itemMap.get("stargazers_count")).intValue();
            int forksCount = ((Number)itemMap.get("forks_count")).intValue();
            String language = (String)itemMap.get("language");
            return new Repository(id, name, fullName, description, htmlUrl, stargazersCount, forksCount, language);
        }).collect(Collectors.toList());
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="GitHub Repository search request")
    public record Request(@JsonProperty(required=true, value="query") @JsonPropertyDescription(value="Keywords used for queries, useful for getting a list of repositories") String query, @JsonProperty(value="sort") @JsonPropertyDescription(value="Sorts the results of your query by number of stars, forks, or help-wanted-issues or how recently the items were updated.") String sort, @JsonProperty(value="order") @JsonPropertyDescription(value="Determines whether the first search result returned is the highest number of matches (desc) or lowest number of matches (asc). This parameter is ignored unless you provide sort.") String order) {
    }

    public record Repository(long id, String name, String fullName, String description, String htmlUrl, int stargazersCount, int forksCount, String language) {
    }
}

