/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.githubtoolkit;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.GithubToolKitProperties;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.Response;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePullRequestService
implements Function<Request, Response> {
    private static final String REPO_ENDPOINT = "/repos/{owner}/{repo}";
    protected static final String PULL_REQUESTS_ENDPOINT = "/pulls";
    private static final Logger logger = LoggerFactory.getLogger(CreatePullRequestService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;
    private final GithubToolKitProperties properties;

    public CreatePullRequestService(GithubToolKitProperties properties, WebClientTool webClientTool, JsonParseTool jsonParseTool) {
        assert (properties.getToken() != null && properties.getToken().length() == 40);
        this.properties = properties;
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
    }

    @Override
    public Response apply(Request request) {
        try {
            String endpoint = "/repos/{owner}/{repo}/pulls";
            HashMap<String, Object> body = new HashMap<String, Object>();
            this.addIfNotNull(body, "title", request.pullRequestTitle());
            this.addIfNotNull(body, "body", request.pullRequestBody());
            this.addIfNotNull(body, "head", request.pullRequestHead());
            this.addIfNotNull(body, "base", request.pullRequestBase());
            this.addIfNotNull(body, "head_repo", request.headRepo());
            this.addIfNotNull(body, "issue", request.issue());
            this.addIfNotNull(body, "draft", request.draft());
            String responseData = (String)this.webClientTool.post(endpoint, Map.of("owner", this.properties.getOwner(), "repo", this.properties.getRepository()), body).block();
            logger.info("Pull request created successfully.");
            return new Response<PullRequest>(this.parsePullRequest(responseData));
        }
        catch (IOException e) {
            logger.error("Error parsing pull request data: {}", (Object)e.getMessage());
            throw new RuntimeException("Error parsing response", e);
        }
        catch (Exception e) {
            logger.error("Unexpected error: {}", (Object)e.getMessage());
            throw new RuntimeException("Unexpected error", e);
        }
    }

    private void addIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public PullRequest parsePullRequest(String json) throws JsonProcessingException {
        Map prMap = this.jsonParseTool.jsonToMap(json, Object.class);
        long id = ((Number)prMap.get("id")).longValue();
        String title = (String)prMap.get("title");
        String state = (String)prMap.get("state");
        int prNumber = ((Number)prMap.get("number")).intValue();
        String body = (String)prMap.get("body");
        String htmlUrl = (String)prMap.get("html_url");
        String userLogin = this.jsonParseTool.getDepthFieldValueAsString(json, new String[]{"user", "login"}).replaceAll("\"", "");
        String headRef = this.jsonParseTool.getDepthFieldValueAsString(json, new String[]{"head", "ref"}).replaceAll("\"", "");
        String baseRef = this.jsonParseTool.getDepthFieldValueAsString(json, new String[]{"base", "ref"}).replaceAll("\"", "");
        return new PullRequest(id, title, state, prNumber, userLogin, body, htmlUrl, headRef, baseRef);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="GitHub Pull Request creation request")
    public record Request(@JsonProperty(required=true, value="pullRequestTitle") @JsonPropertyDescription(value="the title of the Pull Request") String pullRequestTitle, @JsonProperty(required=true, value="pullRequestBody") @JsonPropertyDescription(value="the description of the Pull Request") String pullRequestBody, @JsonProperty(required=true, value="pullRequestHead") @JsonPropertyDescription(value="The name of the branch where your changes are implemented.") String pullRequestHead, @JsonProperty(required=true, value="pullRequestBase") @JsonPropertyDescription(value="The name of the branch you want the changes pulled into.") String pullRequestBase, @JsonProperty(value="headRepo") @JsonPropertyDescription(value="The name of the repository where the changes in the pull request were made. This field is required for cross-repository pull requests if both repositories are owned by the same organization.") String headRepo, @JsonProperty(value="issue") @JsonPropertyDescription(value="An issue in the repository to convert to a pull request. The issue title, body, and comments will become the title, body, and comments on the new pull request. Required unless title is specified.") String issue, @JsonProperty(value="draft") @JsonPropertyDescription(value="Indicates whether the pull request is a draft.") boolean draft) {
    }

    public record PullRequest(long id, String title, String state, Integer prNumber, String userLogin, String body, String htmlUrl, String headRef, String baseRef) {
    }
}

