/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.redis;

import com.alibaba.cloud.ai.memory.redis.BaseRedisChatMemoryRepository;
import com.alibaba.cloud.ai.memory.redis.builder.RedisChatMemoryBuilder;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.SslOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LettuceRedisChatMemoryRepository
extends BaseRedisChatMemoryRepository {
    private static final Logger logger = LoggerFactory.getLogger(LettuceRedisChatMemoryRepository.class);
    private final RedisConnectionFactory connectionFactory;
    private final RedisTemplate<String, String> redisTemplate;

    private LettuceRedisChatMemoryRepository(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory cannot be null");
        this.connectionFactory = connectionFactory;
        this.redisTemplate = this.createRedisTemplate(connectionFactory);
    }

    private RedisTemplate<String, String> createRedisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate(connectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    public static RedisBuilder builder() {
        return new RedisBuilder();
    }

    public List<String> findConversationIds() {
        Set keys = this.redisTemplate.keys((Object)"spring_ai_alibaba_chat_memory:*");
        return keys.stream().map(key -> key.substring("spring_ai_alibaba_chat_memory:".length())).collect(Collectors.toList());
    }

    public List<Message> findByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        List messageStrings = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)messageStrings)) {
            return Collections.emptyList();
        }
        return messageStrings.stream().map(this::deserializeMessage).collect(Collectors.toList());
    }

    public void saveAll(String conversationId, List<Message> messages) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        List<String> messageJsons = messages.stream().map(this::serializeMessage).toList();
        try (RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();){
            connection.keyCommands().del((byte[][])new byte[][]{key.getBytes()});
            if (!messageJsons.isEmpty()) {
                byte[][] values = new byte[messageJsons.size()][];
                for (int i = 0; i < messageJsons.size(); ++i) {
                    values[i] = messageJsons.get(i).getBytes();
                }
                connection.listCommands().rPush(key.getBytes(), (byte[][])values);
            }
        }
    }

    public void deleteByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        this.redisTemplate.delete((Object)("spring_ai_alibaba_chat_memory:" + conversationId));
    }

    public void clearOverLimit(String conversationId, int maxLimit, int deleteSize) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        Long size = this.redisTemplate.opsForList().size((Object)key);
        if (size < (long)maxLimit) {
            return;
        }
        this.redisTemplate.opsForList().trim((Object)key, (long)deleteSize, -1L);
    }

    @Override
    public void close() {
        if (this.connectionFactory instanceof LettuceConnectionFactory) {
            ((LettuceConnectionFactory)this.connectionFactory).destroy();
            logger.info("Lettuce Redis connection pool closed");
        }
    }

    public static class RedisBuilder
    extends RedisChatMemoryBuilder<RedisBuilder> {
        private GenericObjectPoolConfig<?> poolConfig;

        @Override
        protected RedisBuilder self() {
            return this;
        }

        public RedisBuilder poolConfig(GenericObjectPoolConfig<?> poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }

        public LettuceRedisChatMemoryRepository build() {
            LettuceConnectionFactory lettuceConnectionFactory;
            if (this.useCluster) {
                RedisClusterConfiguration clusterConfig = new RedisClusterConfiguration(Set.copyOf(this.nodes));
                if (StringUtils.hasText((String)this.username)) {
                    clusterConfig.setUsername(this.username);
                }
                if (StringUtils.hasText((String)this.password)) {
                    clusterConfig.setPassword(this.password);
                }
                lettuceConnectionFactory = new LettuceConnectionFactory(clusterConfig, this.applyConfiguration());
            } else {
                RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration(this.host, this.port);
                if (StringUtils.hasText((String)this.username)) {
                    standaloneConfig.setUsername(this.username);
                }
                if (StringUtils.hasText((String)this.password)) {
                    standaloneConfig.setPassword(this.password);
                }
                lettuceConnectionFactory = new LettuceConnectionFactory(standaloneConfig, this.applyConfiguration());
            }
            lettuceConnectionFactory.setShareNativeConnection(false);
            lettuceConnectionFactory.afterPropertiesSet();
            return new LettuceRedisChatMemoryRepository((RedisConnectionFactory)lettuceConnectionFactory);
        }

        private LettuceClientConfiguration applyConfiguration() {
            LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder().poolConfig(this.createDefaultPoolConfig());
            builder.commandTimeout(Duration.ofMillis(this.timeout));
            ClientOptions.Builder clientOptions = this.createClientOptions();
            if (this.useSsl && StringUtils.hasText((String)this.bundle)) {
                if (this.sslBundles == null) {
                    throw new IllegalStateException("spring.ssl configuration is required when use SSL in redis chat memory");
                }
                builder.useSsl();
                SslBundle sslBundle = this.sslBundles.getBundle(this.bundle);
                SslOptions.Builder sslOptionsBuilder = io.lettuce.core.SslOptions.builder();
                sslOptionsBuilder.keyManager(sslBundle.getManagers().getKeyManagerFactory());
                sslOptionsBuilder.trustManager(sslBundle.getManagers().getTrustManagerFactory());
                SslOptions sslOptions = sslBundle.getOptions();
                if (sslOptions.getCiphers() != null) {
                    sslOptionsBuilder.cipherSuites(sslOptions.getCiphers());
                }
                if (sslOptions.getEnabledProtocols() != null) {
                    sslOptionsBuilder.protocols(sslOptions.getEnabledProtocols());
                }
                clientOptions.sslOptions(sslOptionsBuilder.build());
            }
            builder.clientOptions(clientOptions.build());
            return builder.build();
        }

        private GenericObjectPoolConfig<?> createDefaultPoolConfig() {
            if (this.poolConfig != null) {
                return this.poolConfig;
            }
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setMaxTotal(8);
            config.setMaxIdle(8);
            config.setMinIdle(2);
            return config;
        }

        private ClientOptions.Builder createClientOptions() {
            return ClientOptions.builder().socketOptions(SocketOptions.builder().connectTimeout(Duration.ofMillis(this.timeout)).keepAlive(true).build()).autoReconnect(true).disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS);
        }
    }
}

