/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.redis;

import com.alibaba.cloud.ai.memory.redis.BaseRedisChatMemoryRepository;
import com.alibaba.cloud.ai.memory.redis.builder.RedisChatMemoryBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLParameters;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public class JedisRedisChatMemoryRepository
extends BaseRedisChatMemoryRepository {
    private static final Logger logger = LoggerFactory.getLogger(JedisRedisChatMemoryRepository.class);
    private final RedisConnectionFactory connectionFactory;
    private final RedisTemplate<String, String> redisTemplate;

    private JedisRedisChatMemoryRepository(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory cannot be null");
        this.connectionFactory = connectionFactory;
        this.redisTemplate = this.createRedisTemplate(connectionFactory);
    }

    private RedisTemplate<String, String> createRedisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate(connectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    public static RedisBuilder builder() {
        return new RedisBuilder();
    }

    public List<String> findConversationIds() {
        Set keys = this.redisTemplate.keys((Object)"spring_ai_alibaba_chat_memory:*");
        return keys.stream().map(key -> key.substring("spring_ai_alibaba_chat_memory:".length())).collect(Collectors.toList());
    }

    public List<Message> findByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        List messageStrings = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)messageStrings)) {
            return Collections.emptyList();
        }
        return messageStrings.stream().map(this::deserializeMessage).collect(Collectors.toList());
    }

    public void saveAll(String conversationId, List<Message> messages) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        List<String> messageJsons = messages.stream().map(this::serializeMessage).toList();
        try (RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();){
            connection.keyCommands().del((byte[][])new byte[][]{key.getBytes()});
            if (!messageJsons.isEmpty()) {
                byte[][] values = new byte[messageJsons.size()][];
                for (int i = 0; i < messageJsons.size(); ++i) {
                    values[i] = messageJsons.get(i).getBytes();
                }
                connection.listCommands().rPush(key.getBytes(), (byte[][])values);
            }
        }
    }

    public void deleteByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        this.redisTemplate.delete((Object)("spring_ai_alibaba_chat_memory:" + conversationId));
    }

    public void clearOverLimit(String conversationId, int maxLimit, int deleteSize) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        Long size = this.redisTemplate.opsForList().size((Object)key);
        if (size < (long)maxLimit) {
            return;
        }
        this.redisTemplate.opsForList().trim((Object)key, (long)deleteSize, -1L);
    }

    @Override
    public void close() {
        if (this.connectionFactory instanceof JedisConnectionFactory) {
            ((JedisConnectionFactory)this.connectionFactory).destroy();
            logger.info("Jedis Redis connection pool closed");
        }
    }

    public static class RedisBuilder
    extends RedisChatMemoryBuilder<RedisBuilder> {
        private JedisPoolConfig poolConfig;

        @Override
        protected RedisBuilder self() {
            return this;
        }

        public JedisRedisChatMemoryRepository build() {
            JedisConnectionFactory jedisConnectionFactory;
            if (this.useCluster) {
                RedisClusterConfiguration clusterConfig = new RedisClusterConfiguration(Set.copyOf(this.nodes));
                if (StringUtils.hasText((String)this.username)) {
                    clusterConfig.setUsername(this.username);
                }
                if (StringUtils.hasText((String)this.password)) {
                    clusterConfig.setPassword(this.password);
                }
                jedisConnectionFactory = new JedisConnectionFactory(clusterConfig, this.applyConfiguration());
            } else {
                RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration(this.host, this.port);
                if (StringUtils.hasText((String)this.username)) {
                    standaloneConfig.setUsername(this.username);
                }
                if (StringUtils.hasText((String)this.password)) {
                    standaloneConfig.setPassword(this.password);
                }
                jedisConnectionFactory = new JedisConnectionFactory(standaloneConfig, this.applyConfiguration());
            }
            jedisConnectionFactory.afterPropertiesSet();
            return new JedisRedisChatMemoryRepository((RedisConnectionFactory)jedisConnectionFactory);
        }

        private JedisPoolConfig getPoolConfigWithDefault() {
            return this.poolConfig != null ? this.poolConfig : new JedisPoolConfig();
        }

        private JedisClientConfiguration applyConfiguration() {
            JedisClientConfiguration.JedisClientConfigurationBuilder builder = JedisClientConfiguration.builder();
            builder.readTimeout(Duration.ofMillis(this.timeout)).connectTimeout(Duration.ofMillis(this.timeout));
            if (this.useSsl && StringUtils.hasText((String)this.bundle)) {
                JedisClientConfiguration.JedisSslClientConfigurationBuilder sslBuilder = builder.useSsl();
                if (this.sslBundles == null) {
                    throw new IllegalStateException("spring.ssl configuration is required when use SSL in redis chat memory");
                }
                SslBundle sslBundle = this.sslBundles.getBundle(this.bundle);
                sslBuilder.sslSocketFactory(sslBundle.createSslContext().getSocketFactory());
                SslOptions sslOptions = sslBundle.getOptions();
                SSLParameters sslParameters = new SSLParameters();
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from((Object)sslOptions.getCiphers()).to(sslParameters::setCipherSuites);
                map.from((Object)sslOptions.getEnabledProtocols()).to(sslParameters::setProtocols);
                sslBuilder.sslParameters(sslParameters);
            }
            builder.usePooling().poolConfig((GenericObjectPoolConfig)this.getPoolConfigWithDefault());
            return builder.build();
        }
    }
}

