/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.observation.model.semconv;

import com.alibaba.cloud.ai.observation.model.semconv.InputOutputModel;
import java.util.ArrayList;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.model.Generation;
import org.springframework.util.StringUtils;

public final class InputOutputUtils {
    public static InputOutputModel.ChatMessage convertFromMessage(Message message) {
        ArrayList<InputOutputModel.MessagePart> messageParts;
        String role;
        block4: {
            block3: {
                role = InputOutputUtils.getRole(message.getMessageType());
                messageParts = new ArrayList<InputOutputModel.MessagePart>();
                if (StringUtils.hasText((String)message.getText())) {
                    messageParts.add(new InputOutputModel.TextPart("text", message.getText()));
                }
                if (!(message instanceof AssistantMessage) || !((AssistantMessage)message).hasToolCalls()) break block3;
                for (AssistantMessage.ToolCall toolCall : ((AssistantMessage)message).getToolCalls()) {
                    messageParts.add(new InputOutputModel.ToolCallRequestPart("tool_call", toolCall.id(), toolCall.name(), toolCall.arguments()));
                }
                break block4;
            }
            if (!(message instanceof ToolResponseMessage) || ((ToolResponseMessage)message).getResponses().isEmpty()) break block4;
            for (ToolResponseMessage.ToolResponse response : ((ToolResponseMessage)message).getResponses()) {
                messageParts.add(new InputOutputModel.ToolCallResponsePart("tool_call_response", response.id(), response.responseData()));
            }
        }
        return new InputOutputModel.ChatMessage(role, messageParts);
    }

    public static InputOutputModel.OutputMessage convertFromGeneration(Generation generation) {
        String finishReason = generation.getMetadata().getFinishReason();
        String role = InputOutputUtils.getRole(generation.getOutput().getMessageType());
        ArrayList<InputOutputModel.MessagePart> messageParts = new ArrayList<InputOutputModel.MessagePart>();
        if (generation.getOutput().hasToolCalls()) {
            for (AssistantMessage.ToolCall toolCall : generation.getOutput().getToolCalls()) {
                messageParts.add(new InputOutputModel.ToolCallRequestPart("tool_call", toolCall.id(), toolCall.name(), toolCall.arguments()));
            }
        }
        if (StringUtils.hasText((String)generation.getOutput().getText())) {
            messageParts.add(new InputOutputModel.TextPart("text", generation.getOutput().getText()));
        }
        return new InputOutputModel.OutputMessage(role, messageParts, finishReason);
    }

    private static String getRole(MessageType messageType) {
        if (messageType == MessageType.USER) {
            return InputOutputModel.RoleEnum.USER.value;
        }
        if (messageType == MessageType.TOOL) {
            return InputOutputModel.RoleEnum.TOOL.value;
        }
        if (messageType == MessageType.ASSISTANT) {
            return InputOutputModel.RoleEnum.ASSISTANT.value;
        }
        if (messageType == MessageType.SYSTEM) {
            return InputOutputModel.RoleEnum.SYSTEM.value;
        }
        return InputOutputModel.RoleEnum.UNKNOWN.value;
    }
}

