/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.dto.schema.SchemaDTO;
import com.alibaba.cloud.ai.service.base.BaseNl2SqlService;
import com.alibaba.cloud.ai.service.base.BaseSchemaService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class Nl2SqlService {
    private static final Logger log = LoggerFactory.getLogger(Nl2SqlService.class);
    private final BaseNl2SqlService baseNl2SqlService;
    private final BaseSchemaService baseSchemaService;

    public Nl2SqlService(@Qualifier(value="nl2SqlServiceImpl") BaseNl2SqlService baseNl2SqlService, @Qualifier(value="schemaServiceImpl") BaseSchemaService baseSchemaService) {
        this.baseNl2SqlService = baseNl2SqlService;
        this.baseSchemaService = baseSchemaService;
    }

    public String apply(String query) throws Exception {
        if ("\u610f\u56fe\u6a21\u7cca\u9700\u8981\u6f84\u6e05".equals(query = this.baseNl2SqlService.rewrite(query)) || "\u95f2\u804a\u62d2\u8bc6".equals(query)) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u81ea\u7136\u8bed\u8a00\u5c5e\u4e8e\u3010".concat(query).concat("\u3011\uff0c\u65e0\u6cd5\u8f6c\u4e3aSQL\u8bed\u8a00"));
        }
        log.info("\u95ee\u9898\u91cd\u5199\u7ed3\u679c\uff1a{}", (Object)query);
        List<String> expandedQuestions = this.baseNl2SqlService.expandQuestion(query);
        log.info("\u95ee\u9898\u6269\u5c55\u7ed3\u679c: {}", expandedQuestions);
        List<String> evidences = this.baseNl2SqlService.extractEvidences(query);
        List<String> keywords = this.baseNl2SqlService.extractKeywords(query, evidences);
        log.info("\u589e\u5f3a\u63d0\u53d6\u7ed3\u679c - \u8bc1\u636e: {}, \u5173\u952e\u8bcd: {}", evidences, keywords);
        List<Document> tableDocuments = this.baseSchemaService.getTableDocuments(query);
        List<List<Document>> columnDocumentsByKeywords = this.baseSchemaService.getColumnDocumentsByKeywords(keywords);
        log.info("Schema recall results - table documents count: {}, keyword-related column document groups: {}", (Object)tableDocuments.size(), (Object)columnDocumentsByKeywords.size());
        SchemaDTO schemaDTO = new SchemaDTO();
        this.baseSchemaService.extractDatabaseName(schemaDTO);
        this.baseSchemaService.buildSchemaFromDocuments(columnDocumentsByKeywords, tableDocuments, schemaDTO);
        log.info("Executing regular schema selection");
        schemaDTO = this.baseNl2SqlService.fineSelect(schemaDTO, query, evidences);
        log.info("Schema result: {}", (Object)schemaDTO);
        return this.baseNl2SqlService.generateSql(evidences, query, schemaDTO);
    }
}

