/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dispatcher;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.EdgeAction;
import com.alibaba.cloud.ai.util.StateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanExecutorDispatcher
implements EdgeAction {
    private static final Logger logger = LoggerFactory.getLogger(PlanExecutorDispatcher.class);
    private static final int MAX_REPAIR_ATTEMPTS = 2;

    public String apply(OverAllState state) {
        boolean validationPassed = StateUtils.getObjectValue(state, "PLAN_VALIDATION_STATUS", Boolean.class, false);
        if (validationPassed) {
            logger.info("Plan validation passed. Proceeding to next step.");
            return (String)state.value("PLAN_NEXT_NODE", (Object)"__END__");
        }
        int repairCount = StateUtils.getObjectValue(state, "PLAN_REPAIR_COUNT", Integer.class, 0);
        if (repairCount > 2) {
            logger.error("Plan repair attempts exceeded the limit of {}. Terminating execution.", (Object)2);
            return "__END__";
        }
        logger.warn("Plan validation failed. Routing back to PlannerNode for repair. Attempt count from state: {}.", (Object)repairCount);
        return "PLANNER_NODE";
    }
}

