/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.config;

import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration
public class RestConfiguration {
    @Value(value="${rest.connect.timeout:600}")
    private long connectTimeout;
    @Value(value="${rest.read.timeout:600}")
    private long readTimeout;
    @Value(value="${webclient.response.timeout:600}")
    private long responseTimeout;

    @Bean
    public RestClientCustomizer restClientCustomizer() {
        return restClientBuilder -> restClientBuilder.requestFactory(ClientHttpRequestFactoryBuilder.reactor().withCustomizer(factory -> {
            factory.setConnectTimeout(Duration.ofSeconds(this.connectTimeout));
            factory.setReadTimeout(Duration.ofSeconds(this.readTimeout));
        }).build());
    }

    @Bean
    public WebClient.Builder webClientBuilder() {
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.create().responseTimeout(Duration.ofSeconds(this.responseTimeout))));
    }
}

