/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.register;

import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.cloud.ai.mcp.register.NacosMcpRegister;
import com.alibaba.cloud.ai.mcp.register.NacosMcpRegisterProperties;
import com.alibaba.cloud.ai.mcp.register.utils.CheckCompatibleResult;
import com.alibaba.cloud.ai.mcp.register.utils.JsonSchemaUtil;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpTool;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.ai.model.mcp.registry.ServerVersionDetail;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerProperties;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerSseProperties;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerStreamableHttpProperties;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;

public class NacosStatelessMcpRegister
implements ApplicationListener<WebServerInitializedEvent> {
    private static final Logger log = LoggerFactory.getLogger(NacosMcpRegister.class);
    private String type;
    private NacosMcpRegisterProperties nacosMcpRegistryProperties;
    private NacosMcpProperties nacosMcpProperties;
    private McpSchema.Implementation serverInfo;
    private McpStatelessAsyncServer mcpStatelessAsyncServer;
    private CopyOnWriteArrayList<McpStatelessServerFeatures.AsyncToolSpecification> tools;
    private Map<String, McpToolMeta> toolsMeta;
    private McpSchema.ServerCapabilities serverCapabilities;
    private McpServerProperties mcpServerProperties;
    private McpServerSseProperties mcpServerSseProperties;
    private ApplicationContext applicationContext;
    private McpServerStreamableHttpProperties mcpServerStreamableHttpProperties;
    private NacosMcpOperationService nacosMcpOperationService;
    private McpServerDetailInfo serverDetailInfo;
    private boolean success = false;

    public NacosStatelessMcpRegister(NacosMcpOperationService nacosMcpOperationService, McpStatelessAsyncServer mcpStatelessAsyncServer, NacosMcpProperties nacosMcpProperties, NacosMcpRegisterProperties nacosMcpRegistryProperties, McpServerProperties mcpServerProperties, McpServerSseProperties mcpServerSseProperties, ApplicationContext applicationContext, String type) {
        this.mcpStatelessAsyncServer = mcpStatelessAsyncServer;
        log.info("Mcp server type: {}", (Object)type);
        this.type = type;
        this.nacosMcpProperties = nacosMcpProperties;
        this.nacosMcpRegistryProperties = nacosMcpRegistryProperties;
        this.nacosMcpOperationService = nacosMcpOperationService;
        this.mcpServerProperties = mcpServerProperties;
        this.mcpServerSseProperties = mcpServerSseProperties;
        this.applicationContext = applicationContext;
        this.mcpServerStreamableHttpProperties = (McpServerStreamableHttpProperties)this.applicationContext.getBean(McpServerStreamableHttpProperties.class);
        try {
            block24: {
                if (StringUtils.isBlank((CharSequence)this.mcpServerProperties.getVersion())) {
                    throw new IllegalArgumentException("[Nacos MCP Register] The version number of Mcp Server is empty; you need to specify a version number.");
                }
                this.serverInfo = mcpStatelessAsyncServer.getServerInfo();
                this.serverCapabilities = mcpStatelessAsyncServer.getServerCapabilities();
                Field toolsField = McpStatelessAsyncServer.class.getDeclaredField("tools");
                toolsField.setAccessible(true);
                this.tools = (CopyOnWriteArrayList)toolsField.get(this.mcpStatelessAsyncServer);
                this.toolsMeta = new HashMap<String, McpToolMeta>();
                McpServerDetailInfo serverDetailInfo = null;
                try {
                    serverDetailInfo = this.nacosMcpOperationService.getServerDetail(this.serverInfo.name(), this.serverInfo.version());
                }
                catch (NacosException e) {
                    log.info("[Nacos MCP Register] Can not found McpServer {} info from nacos, try to register info of local MCP Server {}, version:{} to Nacos", new Object[]{this.serverInfo.name(), this.serverInfo.name(), this.mcpServerProperties.getVersion()});
                }
                if (serverDetailInfo != null) {
                    try {
                        CheckCompatibleResult checkResult = this.checkCompatible(serverDetailInfo);
                        if (!checkResult.isCompatible()) {
                            log.error("[Nacos MCP Register] Check mcp server compatible false, caused by:{}", (Object)checkResult.getMessage());
                            throw new Exception("[Nacos MCP Register] Check mcp server compatible false, caused by:" + checkResult.getMessage());
                        }
                    }
                    catch (Exception e) {
                        log.error("[Nacos MCP Register] Check mcp server compatible failed", (Throwable)e);
                        throw e;
                    }
                    this.serverDetailInfo = serverDetailInfo;
                    if (this.serverCapabilities.tools() != null) {
                        this.updateTools(serverDetailInfo);
                    }
                    this.subscribe();
                    this.success = true;
                    return;
                }
                McpToolSpecification mcpToolSpec = new McpToolSpecification();
                if (this.serverCapabilities.tools() != null) {
                    List<McpSchema.Tool> toolsNeedtoRegister = this.tools.stream().map(McpStatelessServerFeatures.AsyncToolSpecification::tool).toList();
                    String toolsStr = JacksonUtils.toJson(toolsNeedtoRegister);
                    List toolsToNacosList = (List)JacksonUtils.toObj((String)toolsStr, (TypeReference)new TypeReference<List<McpTool>>(){});
                    mcpToolSpec.setTools(toolsToNacosList);
                }
                ServerVersionDetail serverVersionDetail = new ServerVersionDetail();
                serverVersionDetail.setVersion(this.serverInfo.version());
                McpServerBasicInfo serverBasicInfo = new McpServerBasicInfo();
                serverBasicInfo.setName(this.serverInfo.name());
                serverBasicInfo.setVersionDetail(serverVersionDetail);
                String description = this.mcpServerProperties.getInstructions();
                if (StringUtils.isBlank((CharSequence)description)) {
                    description = this.serverInfo.name();
                }
                serverBasicInfo.setDescription(description);
                McpEndpointSpec endpointSpec = new McpEndpointSpec();
                if (StringUtils.equals((CharSequence)this.type, (CharSequence)"stdio")) {
                    serverBasicInfo.setProtocol("stdio");
                    serverBasicInfo.setFrontProtocol("stdio");
                } else {
                    endpointSpec.setType("REF");
                    HashMap<String, String> endpointSpecData = new HashMap<String, String>();
                    endpointSpecData.put("serviceName", this.getRegisterServiceName());
                    String groupName = StringUtils.isBlank((CharSequence)this.nacosMcpRegistryProperties.getServiceGroup()) ? "DEFAULT_GROUP" : this.nacosMcpRegistryProperties.getServiceGroup();
                    endpointSpecData.put("groupName", groupName);
                    endpointSpec.setData(endpointSpecData);
                    McpServerRemoteServiceConfig remoteServerConfigInfo = new McpServerRemoteServiceConfig();
                    String contextPath = this.nacosMcpRegistryProperties.getSseExportContextPath();
                    if (StringUtils.isBlank((CharSequence)contextPath)) {
                        contextPath = "";
                    }
                    if (StringUtils.equals((CharSequence)this.type, (CharSequence)"mcp-sse")) {
                        remoteServerConfigInfo.setExportPath(contextPath + this.mcpServerSseProperties.getSseEndpoint());
                        serverBasicInfo.setRemoteServerConfig(remoteServerConfigInfo);
                        serverBasicInfo.setProtocol("mcp-sse");
                        serverBasicInfo.setFrontProtocol("mcp-sse");
                    } else {
                        if (this.mcpServerStreamableHttpProperties != null) {
                            remoteServerConfigInfo.setExportPath(contextPath + this.mcpServerStreamableHttpProperties.getMcpEndpoint());
                        } else {
                            remoteServerConfigInfo.setExportPath(contextPath + "/mcp");
                        }
                        serverBasicInfo.setRemoteServerConfig(remoteServerConfigInfo);
                        serverBasicInfo.setProtocol("mcp-streamable");
                        serverBasicInfo.setFrontProtocol("mcp-streamable");
                    }
                }
                try {
                    this.nacosMcpOperationService.createMcpServer(this.serverInfo.name(), serverBasicInfo, mcpToolSpec, endpointSpec);
                }
                catch (NacosException e) {
                    McpServerDetailInfo recheckServerDetailInfo = null;
                    try {
                        recheckServerDetailInfo = this.nacosMcpOperationService.getServerDetail(this.serverInfo.name(), this.serverInfo.version());
                    }
                    catch (NacosException remoteServerConfigInfo) {
                        // empty catch block
                    }
                    if (recheckServerDetailInfo == null) {
                        log.info("Mcp server " + this.serverInfo.name() + "exist ,try to update");
                        this.nacosMcpOperationService.updateMcpServer(this.serverInfo.name(), serverBasicInfo, mcpToolSpec, endpointSpec);
                    }
                    CheckCompatibleResult checkResult = this.checkCompatible(recheckServerDetailInfo);
                    if (checkResult.isCompatible()) break block24;
                    log.error("[Nacos MCP Register] Check mcp server compatible false, caused by:{}", (Object)checkResult.getMessage());
                    throw new Exception("[Nacos MCP Register] Check mcp server compatible false, caused by:" + checkResult.getMessage());
                }
            }
            this.subscribe();
            this.success = true;
        }
        catch (Exception e) {
            log.error("[Nacos MCP Register] Failed to register mcp server to nacos", (Throwable)e);
        }
    }

    private void subscribe() {
        this.nacosMcpOperationService.subscribeNacosMcpServer(this.serverInfo.name() + "::" + this.serverInfo.version(), mcpServerDetailInfo -> {
            log.info("[Nacos MCP Register] Received mcp server detail info update event, mcp server name:{}, mcp server version:{}", (Object)this.serverInfo.name(), (Object)this.serverInfo.version());
            if (this.serverCapabilities.tools() != null) {
                this.serverDetailInfo = mcpServerDetailInfo;
                this.updateTools(mcpServerDetailInfo);
            }
        });
    }

    private void updateToolDescription(McpStatelessServerFeatures.AsyncToolSpecification localToolRegistration, McpSchema.Tool toolInNacos, List<McpStatelessServerFeatures.AsyncToolSpecification> toolsRegistrationNeedToUpdate) {
        Boolean changed = false;
        if (localToolRegistration.tool().description() != null && !localToolRegistration.tool().description().equals(toolInNacos.description())) {
            changed = true;
        }
        String localInputSchemaString = JacksonUtils.toJson((Object)localToolRegistration.tool().inputSchema());
        Map localInputSchemaMap = (Map)JacksonUtils.toObj((String)localInputSchemaString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map localProperties = (Map)localInputSchemaMap.get("properties");
        String nacosInputSchemaString = JacksonUtils.toJson((Object)toolInNacos.inputSchema());
        Map nacosInputSchemaMap = (Map)JacksonUtils.toObj((String)nacosInputSchemaString, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        Map nacosProperties = (Map)nacosInputSchemaMap.get("properties");
        for (String key : localProperties.keySet()) {
            if (!nacosProperties.containsKey(key)) continue;
            Map localProperty = (Map)localProperties.get(key);
            Map nacosProperty = (Map)nacosProperties.get(key);
            String localDescription = (String)localProperty.get("description");
            String nacosDescription = (String)nacosProperty.get("description");
            if (nacosDescription == null || nacosDescription.equals(localDescription)) continue;
            localProperty.put("description", nacosDescription);
            changed = true;
        }
        McpSchema.JsonSchema inputSchema = new McpSchema.JsonSchema("object", localInputSchemaMap, localToolRegistration.tool().inputSchema().required(), localToolRegistration.tool().inputSchema().additionalProperties(), localToolRegistration.tool().inputSchema().defs(), localToolRegistration.tool().inputSchema().definitions());
        if (changed.booleanValue()) {
            McpSchema.Tool toolNeededUpdate = new McpSchema.Tool.Builder().name(localToolRegistration.tool().name()).description(toolInNacos.description()).inputSchema(inputSchema).outputSchema(localToolRegistration.tool().outputSchema()).title(localToolRegistration.tool().title()).annotations(localToolRegistration.tool().annotations()).meta(localToolRegistration.tool().meta()).build();
            toolsRegistrationNeedToUpdate.add(new McpStatelessServerFeatures.AsyncToolSpecification(toolNeededUpdate, localToolRegistration.callHandler()));
        }
    }

    private void updateTools(McpServerDetailInfo mcpServerDetailInfo) {
        try {
            boolean changed = false;
            McpToolSpecification toolSpec = mcpServerDetailInfo.getToolSpec();
            if (toolSpec == null) {
                log.info("[Nacos MCP Register] Mcp server tools in nacos is null, skip local mcp server tools update");
                return;
            }
            String toolsInNacosStr = JacksonUtils.toJson((Object)toolSpec.getTools());
            List toolsInNacos = (List)JacksonUtils.toObj((String)toolsInNacosStr, (TypeReference)new TypeReference<List<McpSchema.Tool>>(){});
            changed = this.compareToolsMeta(toolSpec.getToolsMeta());
            this.toolsMeta = toolSpec.getToolsMeta();
            ArrayList<McpStatelessServerFeatures.AsyncToolSpecification> toolsRegistrationNeedToUpdate = new ArrayList<McpStatelessServerFeatures.AsyncToolSpecification>();
            Map<String, McpSchema.Tool> toolsInNacosMap = toolsInNacos.stream().collect(Collectors.toMap(McpSchema.Tool::name, tool -> tool));
            for (McpStatelessServerFeatures.AsyncToolSpecification toolRegistration : this.tools) {
                String name = toolRegistration.tool().name();
                if (!toolsInNacosMap.containsKey(name)) continue;
                McpSchema.Tool toolInNacos = toolsInNacosMap.get(name);
                this.updateToolDescription(toolRegistration, toolInNacos, toolsRegistrationNeedToUpdate);
            }
            if (toolsRegistrationNeedToUpdate.size() > 0) {
                log.info("[Nacos MCP Register] Update tool description for {} tools", (Object)toolsRegistrationNeedToUpdate.size());
            }
            block3: for (McpStatelessServerFeatures.AsyncToolSpecification toolRegistration : toolsRegistrationNeedToUpdate) {
                for (int i = 0; i < this.tools.size(); ++i) {
                    if (!this.tools.get(i).tool().name().equals(toolRegistration.tool().name())) continue;
                    this.tools.set(i, toolRegistration);
                    log.info("[Nacos MCP Register] Update tool description for tool {}", (Object)toolRegistration.tool().name());
                    changed = true;
                    continue block3;
                }
            }
            if (changed) {
                log.info("[Nacos MCP Register] Update tool description finished");
            }
            if (changed && this.serverCapabilities.tools().listChanged().booleanValue()) {
                this.notifyToolsChanged();
            }
        }
        catch (Exception e) {
            log.error("[Nacos MCP Register] Failed to update local tools according to nacos", (Throwable)e);
        }
    }

    public void notifyToolsChanged() {
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        if ("stdio".equals(this.type) || !this.nacosMcpRegistryProperties.isServiceRegister() || !this.success) {
            log.info("[Nacos MCP Register] Stdio mcp server , no need to register mcp server endpoint to nacos");
            return;
        }
        try {
            int port;
            WebServerApplicationContext context = event.getApplicationContext();
            if (context instanceof ConfigurableWebServerApplicationContext && "management".equals(context.getServerNamespace())) {
                return;
            }
            String host = this.nacosMcpRegistryProperties.getHost();
            if (StringUtils.isBlank((CharSequence)host)) {
                host = this.nacosMcpProperties.getIp();
            }
            if (StringUtils.isBlank((CharSequence)host)) {
                host = NetUtils.localIp();
            }
            if ((port = this.nacosMcpRegistryProperties.getPort()) < 0 || port > 65535) {
                port = event.getWebServer().getPort();
            }
            Instance instance = new Instance();
            instance.setIp(host);
            instance.setPort(port);
            instance.setEphemeral(this.nacosMcpRegistryProperties.isServiceEphemeral());
            String groupName = StringUtils.isBlank((CharSequence)this.nacosMcpRegistryProperties.getServiceGroup()) ? "DEFAULT_GROUP" : this.nacosMcpRegistryProperties.getServiceGroup();
            String serviceName = this.getRegisterServiceName();
            if (this.serverDetailInfo != null) {
                serviceName = this.serverDetailInfo.getRemoteServerConfig().getServiceRef().getServiceName();
                groupName = this.serverDetailInfo.getRemoteServerConfig().getServiceRef().getGroupName();
            }
            this.nacosMcpOperationService.registerService(serviceName, groupName, instance);
            log.info("[Nacos MCP Register] Register mcp server endpoint to nacos successfully");
        }
        catch (NacosException e) {
            log.error("[Nacos MCP Register] Failed to register mcp server endpoint to nacos", (Throwable)e);
        }
    }

    private CheckCompatibleResult checkToolsCompatible(McpServerDetailInfo serverDetailInfo) {
        if (serverDetailInfo.getToolSpec() == null || serverDetailInfo.getToolSpec().getTools() == null || serverDetailInfo.getToolSpec().getTools().isEmpty()) {
            return new CheckCompatibleResult(true);
        }
        McpToolSpecification toolSpec = serverDetailInfo.getToolSpec();
        Map<String, McpTool> toolsInNacos = toolSpec.getTools().stream().collect(Collectors.toMap(McpTool::getName, tool -> tool, (existing, replacement) -> replacement));
        Map<String, McpSchema.Tool> toolsInLocal = this.tools.stream().collect(Collectors.toMap(tool -> tool.tool().name(), McpStatelessServerFeatures.AsyncToolSpecification::tool, (existing, replacement) -> replacement));
        if (!toolsInNacos.keySet().equals(toolsInLocal.keySet())) {
            return new CheckCompatibleResult(false, "Local tools list is not compatible with tools list in Nacos");
        }
        for (String toolName : toolsInNacos.keySet()) {
            String jsonSchemaStringInLocal;
            String jsonSchemaStringInNacos = JacksonUtils.toJson((Object)toolsInNacos.get(toolName).getInputSchema());
            if (JsonSchemaUtil.compare(jsonSchemaStringInNacos, jsonSchemaStringInLocal = JacksonUtils.toJson((Object)toolsInLocal.get(toolName).inputSchema()))) continue;
            String message = String.format("Input Schema of local tool %s is not compatible with tool in Nacos", toolName);
            return new CheckCompatibleResult(false, message);
        }
        return new CheckCompatibleResult(true);
    }

    private CheckCompatibleResult checkCompatible(McpServerDetailInfo serverDetailInfo) {
        log.info("[Nacos MCP Register] Checking compatible for mcp server");
        if (!StringUtils.equals((CharSequence)this.serverInfo.version(), (CharSequence)serverDetailInfo.getVersionDetail().getVersion())) {
            return new CheckCompatibleResult(false, "Local version is not compatible with version in Nacos");
        }
        if (!StringUtils.equals((CharSequence)this.type, (CharSequence)serverDetailInfo.getProtocol())) {
            return new CheckCompatibleResult(false, "Local protocol is not compatible with protocol in Nacos");
        }
        if (StringUtils.equals((CharSequence)this.type, (CharSequence)"stdio")) {
            return new CheckCompatibleResult(true);
        }
        McpServiceRef mcpServiceRef = serverDetailInfo.getRemoteServerConfig().getServiceRef();
        if (!this.isServiceRefSame(mcpServiceRef)) {
            return new CheckCompatibleResult(false, "Local service ref is not compatible with service ref in Nacos");
        }
        if (this.serverCapabilities.tools() != null) {
            return this.checkToolsCompatible(serverDetailInfo);
        }
        return new CheckCompatibleResult(true);
    }

    private boolean isServiceRefSame(McpServiceRef serviceRef) {
        if (!StringUtils.isBlank((CharSequence)this.nacosMcpRegistryProperties.getServiceName()) && !StringUtils.equals((CharSequence)serviceRef.getServiceName(), (CharSequence)this.nacosMcpRegistryProperties.getServiceName())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)this.nacosMcpRegistryProperties.getServiceGroup()) && !StringUtils.equals((CharSequence)serviceRef.getGroupName(), (CharSequence)this.nacosMcpRegistryProperties.getServiceGroup())) {
            return false;
        }
        return StringUtils.equals((CharSequence)serviceRef.getNamespaceId(), (CharSequence)this.nacosMcpProperties.getNamespace());
    }

    private String getRegisterServiceName() {
        return StringUtils.isBlank((CharSequence)this.nacosMcpRegistryProperties.getServiceName()) ? this.serverInfo.name() + "::" + this.serverInfo.version() : this.nacosMcpRegistryProperties.getServiceName();
    }

    private boolean compareToolsMeta(Map<String, McpToolMeta> toolsMeta) {
        boolean changed = false;
        if (this.toolsMeta == null && toolsMeta != null || this.toolsMeta != null && toolsMeta == null) {
            return true;
        }
        if (this.toolsMeta == null) {
            return false;
        }
        if (!this.toolsMeta.keySet().equals(toolsMeta.keySet())) {
            return true;
        }
        for (String toolName : toolsMeta.keySet()) {
            if (this.toolsMeta.get(toolName).isEnabled() == toolsMeta.get(toolName).isEnabled()) continue;
            changed = true;
            break;
        }
        return changed;
    }
}

