/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.code.impl;

import com.alibaba.cloud.ai.service.code.CodePoolExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;

public class AiSimulationCodeExecutorService
implements CodePoolExecutorService {
    private static final Logger log = LoggerFactory.getLogger(AiSimulationCodeExecutorService.class);
    private static final String SYSTEM_PROMPT = "\u4f60\u5c06\u6a21\u62dfPython\u7684\u6267\u884c\uff0c\u6839\u636e\u6211\u63d0\u4f9b\u7684\u4ee3\u7801\u548c\u8f93\u5165\u6570\u636e\uff0c\u5e76\u7ed9\u51fa\u6700\u7ec8\u7684\u6570\u636e\u7ed3\u679c\u3002\n\u5728\u6a21\u62df\u8fd0\u884c\u65f6\uff0c\u8bf7\u6309\u7167\u4ee5\u4e0b\u8981\u6c42\u64cd\u4f5c\uff1a\n1. \u4ed4\u7ec6\u7406\u89e3\u4ee3\u7801\u548c\u8f93\u5165\u6570\u636e\u7684\u5185\u5bb9\u3002\n2. \u8f93\u51fa\u6a21\u62df\u8fd0\u884c\u7ed3\u679c\u3002\n**\u8981\u6c42**\uff1a\u4ec5\u8f93\u51fa\u6a21\u62df\u8fd0\u884c\u7ed3\u679c\uff0c\u7981\u6b62\u5305\u542b\u4efb\u4f55\u989d\u5916\u8bf4\u660e\u6216\u81ea\u7136\u8bed\u8a00\u3002\n";
    private final ChatClient chatClient;

    public AiSimulationCodeExecutorService(ChatClient.Builder chatClientBuilder) {
        this.chatClient = chatClientBuilder.defaultSystem(SYSTEM_PROMPT).build();
    }

    @Override
    public CodePoolExecutorService.TaskResponse runTask(CodePoolExecutorService.TaskRequest request) {
        String userPrompt = String.format("\u3010\u4ee3\u7801\u3011\n```python\n%s\n```\n\u3010\u6807\u51c6\u8f93\u5165\u3011\n```json\n%s\n```\n", request.code(), request.input());
        String output = this.chatClient.prompt().user(userPrompt).call().content();
        return CodePoolExecutorService.TaskResponse.success(output);
    }
}

