/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.base;

import com.alibaba.cloud.ai.connector.MdTableGenerator;
import com.alibaba.cloud.ai.connector.accessor.Accessor;
import com.alibaba.cloud.ai.connector.bo.DbQueryParameter;
import com.alibaba.cloud.ai.connector.bo.ResultSetBO;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.dto.schema.ColumnDTO;
import com.alibaba.cloud.ai.dto.schema.SchemaDTO;
import com.alibaba.cloud.ai.dto.schema.TableDTO;
import com.alibaba.cloud.ai.prompt.PromptConstant;
import com.alibaba.cloud.ai.prompt.PromptHelper;
import com.alibaba.cloud.ai.service.LlmService;
import com.alibaba.cloud.ai.service.base.BaseSchemaService;
import com.alibaba.cloud.ai.service.base.BaseVectorStoreService;
import com.alibaba.cloud.ai.util.MarkdownParser;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.document.Document;
import reactor.core.publisher.Flux;

public class BaseNl2SqlService {
    private static final Logger logger = LoggerFactory.getLogger(BaseNl2SqlService.class);
    protected final BaseVectorStoreService vectorStoreService;
    protected final BaseSchemaService schemaService;
    public final LlmService aiService;
    protected final Accessor dbAccessor;
    protected final DbConfig dbConfig;

    public BaseNl2SqlService(BaseVectorStoreService vectorStoreService, BaseSchemaService schemaService, LlmService aiService, Accessor dbAccessor, DbConfig dbConfig) {
        logger.info("Initializing BaseNl2SqlService with components: vectorStoreService={}, schemaService={}, aiService={}, dbAccessor={}, dbConfig={}", new Object[]{vectorStoreService.getClass().getSimpleName(), schemaService.getClass().getSimpleName(), aiService.getClass().getSimpleName(), dbAccessor.getClass().getSimpleName(), dbConfig != null ? dbConfig.getClass().getSimpleName() : "null"});
        this.vectorStoreService = vectorStoreService;
        this.schemaService = schemaService;
        this.aiService = aiService;
        this.dbAccessor = dbAccessor;
        this.dbConfig = dbConfig;
        logger.info("BaseNl2SqlService initialized successfully");
    }

    public Flux<ChatResponse> rewriteStream(String query) throws Exception {
        return this.rewriteStream(query, null);
    }

    public Flux<ChatResponse> rewriteStream(String query, String agentId) throws Exception {
        logger.info("Starting rewriteStream for query: {} with agentId: {}", (Object)query, (Object)agentId);
        String timeRewrittenQuery = this.processTimeExpressions(query);
        logger.debug("Time rewritten query: {} -> {}", (Object)query, (Object)timeRewrittenQuery);
        List<String> evidences = this.extractEvidences(timeRewrittenQuery, agentId);
        logger.debug("Extracted {} evidences for rewriteStream", (Object)evidences.size());
        SchemaDTO schemaDTO = this.select(timeRewrittenQuery, evidences, agentId);
        String prompt = PromptHelper.buildRewritePrompt(timeRewrittenQuery, schemaDTO, evidences);
        logger.debug("Built rewrite prompt for streaming");
        Flux<ChatResponse> result = this.aiService.streamCall(prompt);
        logger.info("RewriteStream completed for query: {}", (Object)query);
        return result;
    }

    public String rewrite(String query) throws Exception {
        logger.info("Starting rewrite for query: {}", (Object)query);
        String timeRewrittenQuery = this.processTimeExpressions(query);
        logger.debug("Time rewritten query: {} -> {}", (Object)query, (Object)timeRewrittenQuery);
        List<String> evidences = this.extractEvidences(timeRewrittenQuery);
        logger.debug("Extracted {} evidences for rewrite", (Object)evidences.size());
        SchemaDTO schemaDTO = this.select(timeRewrittenQuery, evidences);
        String prompt = PromptHelper.buildRewritePrompt(timeRewrittenQuery, schemaDTO, evidences);
        logger.debug("Built rewrite prompt, calling LLM");
        String responseContent = this.aiService.call(prompt);
        String[] splits = responseContent.split("\n");
        logger.debug("Processing LLM response with {} lines", (Object)splits.length);
        for (String line : splits) {
            if (line.startsWith("\u9700\u6c42\u7c7b\u578b\uff1a")) {
                String content = line.substring(5).trim();
                logger.debug("Detected request type: {}", (Object)content);
                if ("\u300a\u81ea\u7531\u95f2\u804a\u300b".equals(content)) {
                    logger.info("Rewrite result: SMALL_TALK_REJECT for query: {}", (Object)query);
                    return "\u95f2\u804a\u62d2\u8bc6";
                }
                if (!"\u300a\u9700\u8981\u6f84\u6e05\u300b".equals(content)) continue;
                logger.info("Rewrite result: INTENT_UNCLEAR for query: {}", (Object)query);
                return "\u610f\u56fe\u6a21\u7cca\u9700\u8981\u6f84\u6e05";
            }
            if (!line.startsWith("\u9700\u6c42\u5185\u5bb9\uff1a")) continue;
            query = line.substring(5);
            logger.debug("Extracted rewritten query: {}", (Object)query);
        }
        logger.info("Rewrite completed successfully for query: {}", (Object)query);
        return query;
    }

    public String processTimeExpressions(String query) {
        try {
            logger.debug("Processing time expressions in query: {}", (Object)query);
            String timeConversionPrompt = PromptHelper.buildTimeConversionPrompt(query);
            String convertedQuery = this.aiService.call(timeConversionPrompt);
            if (!convertedQuery.equals(query)) {
                logger.info("Time expression conversion: {} -> {}", (Object)query, (Object)convertedQuery);
            } else {
                logger.debug("No time expressions found or converted in query: {}", (Object)query);
            }
            return convertedQuery;
        }
        catch (Exception e) {
            logger.warn("Failed to process time expressions using AI, using original query: {}", (Object)e.getMessage());
            return query;
        }
    }

    public String nl2sql(String query) throws Exception {
        logger.info("Starting nl2sql conversion for query: {}", (Object)query);
        List<String> evidences = this.extractEvidences(query);
        logger.debug("Extracted {} evidences for nl2sql", (Object)evidences.size());
        SchemaDTO schemaDTO = this.select(query, evidences);
        String sql = this.generateSql(evidences, query, schemaDTO);
        logger.info("Nl2sql conversion completed. Generated SQL: {}", (Object)sql);
        return sql;
    }

    public String executeSql(String sql) throws Exception {
        logger.info("Executing SQL: {}", (Object)sql);
        try {
            DbQueryParameter param = DbQueryParameter.from((DbConfig)this.dbConfig).setSql(sql);
            logger.debug("Created DbQueryParameter for SQL execution");
            ResultSetBO resultSet = this.dbAccessor.executeSqlAndReturnObject(this.dbConfig, param);
            logger.debug("SQL executed successfully, generating table format");
            String result = MdTableGenerator.generateTable((ResultSetBO)resultSet);
            logger.info("SQL execution completed successfully, result rows: {}", (Object)(resultSet.getData() != null ? resultSet.getData().size() : 0));
            return result;
        }
        catch (Exception e) {
            logger.error("Failed to execute SQL: {}", (Object)sql, (Object)e);
            throw e;
        }
    }

    @Deprecated
    public String semanticConsistency(String sql, String queryPrompt) throws Exception {
        String semanticConsistencyPrompt = PromptHelper.buildSemanticConsistenPrompt(queryPrompt, sql);
        String call = this.aiService.call(semanticConsistencyPrompt);
        return call;
    }

    public Flux<ChatResponse> semanticConsistencyStream(String sql, String queryPrompt) throws Exception {
        String semanticConsistencyPrompt = PromptHelper.buildSemanticConsistenPrompt(queryPrompt, sql);
        logger.info("semanticConsistencyPrompt = {}", (Object)semanticConsistencyPrompt);
        return this.aiService.streamCall(semanticConsistencyPrompt);
    }

    public List<String> expandQuestion(String query) {
        logger.info("Starting question expansion for query: {}", (Object)query);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("question", query);
            String prompt = PromptConstant.getQuestionExpansionPromptTemplate().render(params);
            logger.debug("Calling LLM for question expansion");
            String content = this.aiService.call(prompt);
            List expandedQuestions = (List)new Gson().fromJson(content, new TypeToken<List<String>>(){}.getType());
            if (expandedQuestions == null || expandedQuestions.isEmpty()) {
                logger.warn("No expanded questions generated, returning original query");
                return Collections.singletonList(query);
            }
            logger.info("Question expansion completed successfully: {} questions generated", (Object)expandedQuestions.size());
            logger.debug("Expanded questions: {}", (Object)expandedQuestions);
            return expandedQuestions;
        }
        catch (Exception e) {
            logger.warn("Question expansion failed, returning original query: {}", (Object)e.getMessage());
            return Collections.singletonList(query);
        }
    }

    public List<String> extractEvidences(String query) {
        return this.extractEvidences(query, null);
    }

    public List<String> extractEvidences(String query, String agentId) {
        logger.debug("Extracting evidences for query: {} with agentId: {}", (Object)query, (Object)agentId);
        List<Document> evidenceDocuments = agentId != null && !agentId.trim().isEmpty() ? this.vectorStoreService.getDocumentsForAgent(agentId, query, "evidence") : this.vectorStoreService.getDocuments(query, "evidence");
        List<String> evidences = evidenceDocuments.stream().map(Document::getText).collect(Collectors.toList());
        logger.debug("Extracted {} evidences: {}", (Object)evidences.size(), evidences);
        return evidences;
    }

    public List<String> extractKeywords(String query, List<String> evidenceList) {
        logger.debug("Extracting keywords from query: {} with {} evidences", (Object)query, (Object)evidenceList.size());
        StringBuilder queryBuilder = new StringBuilder(query);
        for (String evidence : evidenceList) {
            queryBuilder.append(evidence).append("\u3002");
        }
        query = queryBuilder.toString();
        String prompt = PromptHelper.buildQueryToKeywordsPrompt(query);
        logger.debug("Calling LLM for keyword extraction");
        String content = this.aiService.call(prompt);
        List keywords = (List)new Gson().fromJson(content, new TypeToken<List<String>>(){}.getType());
        logger.debug("Extracted {} keywords: {}", (Object)(keywords != null ? keywords.size() : 0), (Object)keywords);
        return keywords;
    }

    public SchemaDTO select(String query, List<String> evidenceList) throws Exception {
        return this.select(query, evidenceList, null);
    }

    public SchemaDTO select(String query, List<String> evidenceList, String agentId) throws Exception {
        logger.debug("Starting schema selection for query: {} with {} evidences and agentId: {}", new Object[]{query, evidenceList.size(), agentId});
        List<String> keywords = this.extractKeywords(query, evidenceList);
        logger.debug("Using {} keywords for schema selection", (Object)(keywords != null ? keywords.size() : 0));
        SchemaDTO schemaDTO = agentId != null ? this.schemaService.mixRagForAgent(agentId, query, keywords) : this.schemaService.mixRag(query, keywords);
        logger.debug("Retrieved schema with {} tables", (Object)(schemaDTO.getTable() != null ? schemaDTO.getTable().size() : 0));
        SchemaDTO result = this.fineSelect(schemaDTO, query, evidenceList);
        logger.debug("Fine selection completed, final schema has {} tables", (Object)(result.getTable() != null ? result.getTable().size() : 0));
        return result;
    }

    public String isRecallInfoSatisfyRequirement(String query, SchemaDTO schemaDTO, List<String> evidenceList) {
        logger.debug("Checking if recall info satisfies requirement for query: {}", (Object)query);
        String prompt = PromptHelper.mixSqlGeneratorSystemCheckPrompt(query, this.dbConfig, schemaDTO, evidenceList);
        logger.debug("Calling LLM for requirement satisfaction check");
        String result = this.aiService.call(prompt);
        logger.debug("Requirement satisfaction check result: {}", (Object)result);
        return result;
    }

    public String generateSql(List<String> evidenceList, String query, SchemaDTO schemaDTO, String sql, String exceptionMessage) throws Exception {
        logger.info("Generating SQL for query: {}, hasExistingSql: {}", (Object)query, (Object)(sql != null && !sql.isEmpty() ? 1 : 0));
        logger.debug("Time expressions already processed in rewrite phase");
        String newSql = "";
        if (sql != null && !sql.isEmpty()) {
            logger.debug("Using SQL error fixer for existing SQL: {}", (Object)sql);
            String errorFixerPrompt = PromptHelper.buildSqlErrorFixerPrompt(query, this.dbConfig, schemaDTO, evidenceList, sql, exceptionMessage);
            newSql = this.aiService.call(errorFixerPrompt);
            logger.info("SQL error fixing completed");
        } else {
            logger.debug("Generating new SQL from scratch");
            List<String> prompts = PromptHelper.buildMixSqlGeneratorPrompt(query, this.dbConfig, schemaDTO, evidenceList);
            newSql = this.aiService.callWithSystemPrompt(prompts.get(0), prompts.get(1));
            logger.info("New SQL generation completed");
        }
        String result = MarkdownParser.extractRawText(newSql).trim();
        logger.info("Final generated SQL: {}", (Object)result);
        return result;
    }

    public String generateSql(List<String> evidenceList, String query, SchemaDTO schemaDTO) throws Exception {
        return this.generateSql(evidenceList, query, schemaDTO, null, null);
    }

    public Set<String> fineSelect(SchemaDTO schemaDTO, String sqlGenerateSchemaMissingAdvice) {
        logger.debug("Fine selecting tables based on advice: {}", (Object)sqlGenerateSchemaMissingAdvice);
        String schemaInfo = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String prompt = " \u5efa\u8bae\uff1a" + sqlGenerateSchemaMissingAdvice + " \n \u8bf7\u6309\u7167\u5efa\u8bae\u8fdb\u884c\u8fd4\u56de\u76f8\u5173\u8868\u7684\u540d\u79f0\uff0c\u53ea\u8fd4\u56de\u5efa\u8bae\u4e2d\u63d0\u5230\u7684\u8868\u540d\uff0c\u8fd4\u56de\u683c\u5f0f\u4e3a\uff1a[\"a\",\"b\",\"c\"] \n " + schemaInfo;
        logger.debug("Calling LLM for table selection with advice");
        String content = this.aiService.call(prompt);
        if (content != null && !content.trim().isEmpty()) {
            List tableList;
            String jsonContent = MarkdownParser.extractText(content);
            try {
                tableList = (List)new Gson().fromJson(jsonContent, new TypeToken<List<String>>(){}.getType());
            }
            catch (Exception e) {
                logger.error("Failed to parse table selection response: {}", (Object)jsonContent, (Object)e);
                throw new IllegalStateException(jsonContent);
            }
            if (tableList != null && !tableList.isEmpty()) {
                Set<String> selectedTables = tableList.stream().map(String::toLowerCase).collect(Collectors.toSet());
                logger.debug("Selected {} tables based on advice: {}", (Object)selectedTables.size(), selectedTables);
                return selectedTables;
            }
        }
        logger.debug("No tables selected based on advice");
        return new HashSet<String>();
    }

    public SchemaDTO fineSelect(SchemaDTO schemaDTO, String query, List<String> evidenceList) {
        return this.fineSelect(schemaDTO, query, evidenceList, null);
    }

    public SchemaDTO fineSelect(SchemaDTO schemaDTO, String query, List<String> evidenceList, String sqlGenerateSchemaMissingAdvice) {
        return this.fineSelect(schemaDTO, query, evidenceList, sqlGenerateSchemaMissingAdvice, null);
    }

    public SchemaDTO fineSelect(SchemaDTO schemaDTO, String query, List<String> evidenceList, String sqlGenerateSchemaMissingAdvice, DbConfig specificDbConfig) {
        logger.debug("Fine selecting schema for query: {} with {} evidences and specificDbConfig: {}", new Object[]{query, evidenceList.size(), specificDbConfig != null ? specificDbConfig.getUrl() : "default"});
        SchemaDTO enrichedSchema = this.enrichSchemaWithSampleData(schemaDTO, specificDbConfig);
        logger.debug("Schema enriched with sample data for {} tables", (Object)(enrichedSchema.getTable() != null ? enrichedSchema.getTable().size() : 0));
        String prompt = PromptHelper.buildMixSelectorPrompt(evidenceList, query, enrichedSchema);
        logger.debug("Calling LLM for schema fine selection");
        String content = this.aiService.call(prompt);
        HashSet<String> selectedTables = new HashSet<String>();
        if (sqlGenerateSchemaMissingAdvice != null) {
            logger.debug("Adding tables from schema missing advice");
            selectedTables.addAll(this.fineSelect(schemaDTO, sqlGenerateSchemaMissingAdvice));
        }
        if (content != null && !content.trim().isEmpty()) {
            List tableList;
            String jsonContent = MarkdownParser.extractText(content);
            try {
                tableList = (List)new Gson().fromJson(jsonContent, new TypeToken<List<String>>(){}.getType());
            }
            catch (Exception e) {
                logger.error("Failed to parse fine selection response: {}", (Object)jsonContent, (Object)e);
                throw new IllegalStateException(jsonContent);
            }
            if (tableList != null && !tableList.isEmpty()) {
                selectedTables.addAll(tableList.stream().map(String::toLowerCase).collect(Collectors.toSet()));
                int originalTableCount = schemaDTO.getTable() != null ? schemaDTO.getTable().size() : 0;
                schemaDTO.getTable().removeIf(table -> !selectedTables.contains(table.getName().toLowerCase()));
                int finalTableCount = schemaDTO.getTable() != null ? schemaDTO.getTable().size() : 0;
                logger.debug("Fine selection completed: {} -> {} tables, selected tables: {}", new Object[]{originalTableCount, finalTableCount, selectedTables});
            }
        }
        return schemaDTO;
    }

    private SchemaDTO enrichSchemaWithSampleData(SchemaDTO schemaDTO, DbConfig specificDbConfig) {
        if (schemaDTO == null || schemaDTO.getTable() == null || schemaDTO.getTable().isEmpty()) {
            logger.debug("Schema is null or empty, skipping sample data enrichment");
            return schemaDTO;
        }
        DbConfig targetDbConfig = specificDbConfig != null ? specificDbConfig : this.dbConfig;
        logger.debug("Using database config: {}", (Object)(targetDbConfig != null ? targetDbConfig.getUrl() : "null"));
        if (!this.isDatabaseConfigValid(targetDbConfig)) {
            logger.info("Database configuration is invalid, skipping sample data enrichment for all tables");
            return schemaDTO;
        }
        try {
            SchemaDTO enrichedSchema = this.copySchemaDTO(schemaDTO);
            for (TableDTO tableDTO : enrichedSchema.getTable()) {
                this.enrichTableWithSampleData(tableDTO, targetDbConfig);
            }
            logger.info("Successfully enriched schema with sample data for {} tables", (Object)enrichedSchema.getTable().size());
            return enrichedSchema;
        }
        catch (Exception e) {
            logger.warn("Failed to enrich schema with sample data, using original schema: {}", (Object)e.getMessage());
            return schemaDTO;
        }
    }

    private void enrichTableWithSampleData(TableDTO tableDTO, DbConfig dbConfig) {
        if (tableDTO == null || tableDTO.getColumn() == null || tableDTO.getColumn().isEmpty()) {
            return;
        }
        logger.debug("Enriching table '{}' with sample table data for {} columns", (Object)tableDTO.getName(), (Object)tableDTO.getColumn().size());
        try {
            ResultSetBO tableData = this.getSampleDataForTable(tableDTO.getName(), dbConfig);
            if (tableData != null && tableData.getData() != null && !tableData.getData().isEmpty()) {
                this.distributeTableDataToColumns(tableDTO, tableData);
                logger.info("Successfully enriched table '{}' with {} sample rows", (Object)tableDTO.getName(), (Object)tableData.getData().size());
            } else {
                logger.debug("No sample data found for table '{}'", (Object)tableDTO.getName());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to get sample data for table '{}': {}", (Object)tableDTO.getName(), (Object)e.getMessage());
        }
    }

    private ResultSetBO getSampleDataForTable(String tableName, DbConfig dbConfig) throws Exception {
        DbQueryParameter param = DbQueryParameter.from((DbConfig)dbConfig).setTable(tableName);
        return this.dbAccessor.scanTable(dbConfig, param);
    }

    private void distributeTableDataToColumns(TableDTO tableDTO, ResultSetBO tableData) {
        List columnHeaders = tableData.getColumn();
        List rows = tableData.getData();
        HashMap<String, List> columnSamples = new HashMap<String, List>();
        for (Map row : rows) {
            for (String columnName : columnHeaders) {
                String value = (String)row.get(columnName);
                if (value == null || value.trim().isEmpty()) continue;
                columnSamples.computeIfAbsent(columnName, k -> new ArrayList()).add(value);
            }
        }
        for (ColumnDTO columnDTO : tableDTO.getColumn()) {
            List<String> filteredSamples;
            String columnName = columnDTO.getName();
            List samples = (List)columnSamples.get(columnName);
            if (samples == null || samples.isEmpty() || (filteredSamples = samples.stream().filter(sample -> sample != null && !sample.trim().isEmpty()).distinct().limit(5L).collect(Collectors.toList())).isEmpty()) continue;
            columnDTO.setSamples(filteredSamples);
            logger.debug("Added {} sample values for column '{}.{}': {}", new Object[]{filteredSamples.size(), tableDTO.getName(), columnName, filteredSamples});
        }
    }

    private boolean isDatabaseConfigValid(DbConfig dbConfig) {
        boolean hasBasicInfo;
        if (dbConfig == null) {
            logger.debug("dbConfig is null");
            return false;
        }
        if (this.dbAccessor == null) {
            logger.debug("dbAccessor is null");
            return false;
        }
        boolean bl = hasBasicInfo = dbConfig.getUrl() != null && !dbConfig.getUrl().trim().isEmpty() && dbConfig.getUsername() != null && !dbConfig.getUsername().trim().isEmpty();
        if (!hasBasicInfo) {
            logger.debug("dbConfig missing basic connection info - url: {}, username: {}", (Object)(dbConfig.getUrl() != null ? "present" : "null"), (Object)(dbConfig.getUsername() != null ? "present" : "null"));
            return false;
        }
        return true;
    }

    private SchemaDTO copySchemaDTO(SchemaDTO originalSchema) {
        SchemaDTO copy = new SchemaDTO();
        copy.setName(originalSchema.getName());
        copy.setDescription(originalSchema.getDescription());
        copy.setTableCount(originalSchema.getTableCount());
        copy.setForeignKeys(originalSchema.getForeignKeys());
        if (originalSchema.getTable() != null) {
            List<TableDTO> copiedTables = originalSchema.getTable().stream().map(this::copyTableDTO).collect(Collectors.toList());
            copy.setTable(copiedTables);
        }
        return copy;
    }

    private TableDTO copyTableDTO(TableDTO originalTable) {
        TableDTO copy = new TableDTO();
        copy.setName(originalTable.getName());
        copy.setDescription(originalTable.getDescription());
        copy.setPrimaryKeys(originalTable.getPrimaryKeys());
        if (originalTable.getColumn() != null) {
            List<ColumnDTO> copiedColumns = originalTable.getColumn().stream().map(this::copyColumnDTO).collect(Collectors.toList());
            copy.setColumn(copiedColumns);
        }
        return copy;
    }

    private ColumnDTO copyColumnDTO(ColumnDTO originalColumn) {
        ColumnDTO copy = new ColumnDTO();
        copy.setName(originalColumn.getName());
        copy.setDescription(originalColumn.getDescription());
        copy.setEnumeration(originalColumn.getEnumeration());
        copy.setRange(originalColumn.getRange());
        copy.setType(originalColumn.getType());
        copy.setMapping(originalColumn.getMapping());
        if (originalColumn.getSamples() != null) {
            copy.setSamples(new ArrayList<String>(originalColumn.getSamples()));
        }
        if (originalColumn.getData() != null) {
            copy.setData(new ArrayList<String>(originalColumn.getData()));
        }
        return copy;
    }
}

