/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.Nl2SqlProcess;
import com.alibaba.cloud.ai.graph.CompiledGraph;
import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class Nl2SqlService {
    private static final Logger logger = LoggerFactory.getLogger(Nl2SqlService.class);
    private final CompiledGraph nl2sqlGraph;

    public Nl2SqlService(@Qualifier(value="nl2sqlGraph") StateGraph stateGraph) throws GraphStateException {
        this.nl2sqlGraph = stateGraph.compile();
        this.nl2sqlGraph.setMaxIterations(100);
    }

    public String nl2sql(String naturalQuery, String agentId) throws GraphRunnerException {
        if (agentId == null) {
            agentId = "";
        }
        Map<String, String> stateMap = Map.of("IS_ONLY_NL2SQL", true, "input", naturalQuery, "agentId", agentId);
        Optional call = this.nl2sqlGraph.call(stateMap);
        OverAllState state = (OverAllState)call.orElseThrow(() -> {
            logger.error("Nl2SqlService call fail, stateMap: {}", (Object)stateMap);
            return new GraphRunnerException("\u56fe\u8fd0\u884c\u5931\u8d25");
        });
        return (String)state.value("ONLY_NL2SQL_OUTPUT", (Object)"");
    }

    public String nl2sql(String naturalQuery) throws GraphRunnerException {
        return this.nl2sql(naturalQuery, "");
    }

    public CompletableFuture<Void> nl2sqlWithProcess(Consumer<Nl2SqlProcess> nl2SqlProcessConsumer, String naturalQuery, String agentId, RunnableConfig runnableConfig) throws GraphRunnerException {
        Map<String, String> stateMap = Map.of("IS_ONLY_NL2SQL", true, "input", naturalQuery, "agentId", agentId);
        Consumer<NodeOutput> consumer = output -> {
            Nl2SqlProcess sqlProcess = this.nodeOutputToNl2sqlProcess((NodeOutput)output);
            nl2SqlProcessConsumer.accept(sqlProcess);
        };
        return this.nl2sqlGraph.fluxStream(stateMap, runnableConfig).doOnNext(consumer::accept).then().toFuture();
    }

    public CompletableFuture<Void> nl2sqlWithProcess(Consumer<Nl2SqlProcess> nl2SqlProcessConsumer, String naturalQuery, String agentId) throws GraphRunnerException {
        return this.nl2sqlWithProcess(nl2SqlProcessConsumer, naturalQuery, agentId, RunnableConfig.builder().build());
    }

    public CompletableFuture<Void> nl2sqlWithProcess(Consumer<Nl2SqlProcess> nl2SqlProcessConsumer, String naturalQuery) throws GraphRunnerException {
        return this.nl2sqlWithProcess(nl2SqlProcessConsumer, naturalQuery, "");
    }

    private Nl2SqlProcess nodeOutputToNl2sqlProcess(NodeOutput output) {
        String nodeRes = "";
        if (output instanceof StreamingOutput) {
            StreamingOutput streamingOutput = (StreamingOutput)output;
            nodeRes = streamingOutput.chunk();
        } else {
            nodeRes = output.toString();
        }
        if ("__END__".equals(output.node())) {
            String result = (String)output.state().value("ONLY_NL2SQL_OUTPUT", (Object)"");
            return Nl2SqlProcess.success(result, output.node(), nodeRes);
        }
        return Nl2SqlProcess.processing(output.node(), nodeRes);
    }
}

