/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.prompt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class PromptLoader {
    public static final Logger logger = LoggerFactory.getLogger(PromptLoader.class);
    private static final String PROMPT_PATH_PREFIX = "prompts/";
    private static final ConcurrentHashMap<String, String> promptCache = new ConcurrentHashMap();

    public static String loadPrompt(String promptName) {
        return promptCache.computeIfAbsent(promptName, name -> {
            String string;
            block8: {
                String fileName = PROMPT_PATH_PREFIX + name + ".txt";
                InputStream inputStream = PromptLoader.class.getClassLoader().getResourceAsStream(fileName);
                try {
                    string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("\u52a0\u8f7d\u63d0\u793a\u8bcd\u5931\u8d25\uff01{}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException("\u52a0\u8f7d\u63d0\u793a\u8bcd\u5931\u8d25: " + name, e);
                    }
                }
                inputStream.close();
            }
            return string;
        });
    }

    public static void clearCache() {
        promptCache.clear();
    }

    public static int getCacheSize() {
        return promptCache.size();
    }
}

