/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.entity.UserPromptConfig;
import com.alibaba.cloud.ai.enums.StreamResponseType;
import com.alibaba.cloud.ai.graph.GraphResponse;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import com.alibaba.cloud.ai.model.execution.ExecutionStep;
import com.alibaba.cloud.ai.model.execution.Plan;
import com.alibaba.cloud.ai.prompt.PromptHelper;
import com.alibaba.cloud.ai.service.UserPromptConfigService;
import com.alibaba.cloud.ai.util.StateUtils;
import com.alibaba.cloud.ai.util.StreamingChatGeneratorUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.core.ParameterizedTypeReference;
import reactor.core.publisher.Flux;

public class ReportGeneratorNode
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(ReportGeneratorNode.class);
    private final ChatClient chatClient;
    private final BeanOutputConverter<Plan> converter;
    private final UserPromptConfigService promptConfigService;

    public ReportGeneratorNode(ChatClient.Builder chatClientBuilder, UserPromptConfigService promptConfigService) {
        this.chatClient = chatClientBuilder.build();
        this.converter = new BeanOutputConverter((ParameterizedTypeReference)new ParameterizedTypeReference<Plan>(){});
        this.promptConfigService = promptConfigService;
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        logger.info("Entering {} node", (Object)this.getClass().getSimpleName());
        String plannerNodeOutput = StateUtils.getStringValue(state, "PLANNER_NODE_OUTPUT");
        String userInput = StateUtils.getStringValue(state, "input");
        Integer currentStep = StateUtils.getObjectValue(state, "PLAN_CURRENT_STEP", Integer.class, 1);
        HashMap<String, String> executionResults = StateUtils.getObjectValue(state, "SQL_EXECUTE_NODE_OUTPUT", HashMap.class, new HashMap());
        logger.info("Planner node output: {}", (Object)plannerNodeOutput);
        Plan plan = (Plan)this.converter.convert(plannerNodeOutput);
        ExecutionStep executionStep = this.getCurrentExecutionStep(plan, currentStep);
        String summaryAndRecommendations = executionStep.getToolParameters().getSummaryAndRecommendations();
        Flux<ChatResponse> reportGenerationFlux = this.generateReport(userInput, plan, executionResults, summaryAndRecommendations);
        Flux<GraphResponse<StreamingOutput>> generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), state, "\u5f00\u59cb\u751f\u6210\u62a5\u544a...", "\u62a5\u544a\u751f\u6210\u5b8c\u6210\uff01", reportContent -> {
            logger.info("Generated report content: {}", reportContent);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("result", (String)reportContent);
            result.put("SQL_EXECUTE_NODE_OUTPUT", null);
            result.put("PLAN_CURRENT_STEP", null);
            result.put("PLANNER_NODE_OUTPUT", null);
            return result;
        }, reportGenerationFlux, StreamResponseType.OUTPUT_REPORT);
        return Map.of("result", generator);
    }

    private ExecutionStep getCurrentExecutionStep(Plan plan, Integer currentStep) {
        List<ExecutionStep> executionPlan = plan.getExecutionPlan();
        if (executionPlan == null || executionPlan.isEmpty()) {
            throw new IllegalStateException("Execution plan is empty");
        }
        int stepIndex = currentStep - 1;
        if (stepIndex < 0 || stepIndex >= executionPlan.size()) {
            throw new IllegalStateException("Current step index out of range: " + stepIndex);
        }
        return executionPlan.get(stepIndex);
    }

    private Flux<ChatResponse> generateReport(String userInput, Plan plan, HashMap<String, String> executionResults, String summaryAndRecommendations) {
        String userRequirementsAndPlan = this.buildUserRequirementsAndPlan(userInput, plan);
        String analysisStepsAndData = this.buildAnalysisStepsAndData(plan, executionResults);
        List<UserPromptConfig> optimizationConfigs = this.promptConfigService.getOptimizationConfigs("report-generator");
        String reportPrompt = PromptHelper.buildReportGeneratorPromptWithOptimization(userRequirementsAndPlan, analysisStepsAndData, summaryAndRecommendations, optimizationConfigs);
        logger.info("Using {} prompt for report generation", !optimizationConfigs.isEmpty() ? "optimized (" + optimizationConfigs.size() + " configs)" : "default");
        return this.chatClient.prompt().user(reportPrompt).stream().chatResponse();
    }

    private String buildUserRequirementsAndPlan(String userInput, Plan plan) {
        StringBuilder sb = new StringBuilder();
        sb.append("## \u7528\u6237\u539f\u59cb\u9700\u6c42\n");
        sb.append(userInput).append("\n\n");
        sb.append("## \u6267\u884c\u8ba1\u5212\u6982\u8ff0\n");
        sb.append("**\u601d\u8003\u8fc7\u7a0b**: ").append(plan.getThoughtProcess()).append("\n\n");
        sb.append("## \u8be6\u7ec6\u6267\u884c\u6b65\u9aa4\n");
        List<ExecutionStep> executionPlan = plan.getExecutionPlan();
        for (int i = 0; i < executionPlan.size(); ++i) {
            ExecutionStep step = executionPlan.get(i);
            sb.append("### \u6b65\u9aa4 ").append(i + 1).append(": \u6b65\u9aa4\u7f16\u53f7 ").append(step.getStep()).append("\n");
            sb.append("**\u5de5\u5177**: ").append(step.getToolToUse()).append("\n");
            if (step.getToolParameters() != null) {
                sb.append("**\u53c2\u6570\u63cf\u8ff0**: ").append(step.getToolParameters().getDescription()).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String buildAnalysisStepsAndData(Plan plan, HashMap<String, String> executionResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("## \u6570\u636e\u6267\u884c\u7ed3\u679c\n");
        if (executionResults.isEmpty()) {
            sb.append("\u6682\u65e0\u6267\u884c\u7ed3\u679c\u6570\u636e\n");
        } else {
            List<ExecutionStep> executionPlan = plan.getExecutionPlan();
            for (Map.Entry<String, String> entry : executionResults.entrySet()) {
                String stepKey = entry.getKey();
                String stepResult = entry.getValue();
                sb.append("### ").append(stepKey).append("\n");
                try {
                    int stepIndex = Integer.parseInt(stepKey.replace("step_", "")) - 1;
                    if (stepIndex >= 0 && stepIndex < executionPlan.size()) {
                        ExecutionStep step = executionPlan.get(stepIndex);
                        sb.append("**\u6b65\u9aa4\u7f16\u53f7**: ").append(step.getStep()).append("\n");
                        sb.append("**\u4f7f\u7528\u5de5\u5177**: ").append(step.getToolToUse()).append("\n");
                        if (step.getToolParameters() != null) {
                            sb.append("**\u53c2\u6570\u63cf\u8ff0**: ").append(step.getToolParameters().getDescription()).append("\n");
                            if (step.getToolParameters().getSqlQuery() != null) {
                                sb.append("**\u6267\u884cSQL**: \n```sql\n").append(step.getToolParameters().getSqlQuery()).append("\n```\n");
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                sb.append("**\u6267\u884c\u7ed3\u679c**: \n```json\n").append(stepResult).append("\n```\n\n");
            }
        }
        return sb.toString();
    }
}

