/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.enums.StreamResponseType;
import com.alibaba.cloud.ai.graph.GraphResponse;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import com.alibaba.cloud.ai.node.AbstractPlanBasedNode;
import com.alibaba.cloud.ai.prompt.PromptConstant;
import com.alibaba.cloud.ai.util.StateUtils;
import com.alibaba.cloud.ai.util.StepResultUtils;
import com.alibaba.cloud.ai.util.StreamingChatGeneratorUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;

public class PythonAnalyzeNode
extends AbstractPlanBasedNode
implements NodeAction {
    private static final Logger log = LoggerFactory.getLogger(PythonAnalyzeNode.class);
    private final ChatClient chatClient;

    public PythonAnalyzeNode(ChatClient.Builder chatClientBuilder) {
        this.chatClient = chatClientBuilder.build();
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        this.logNodeEntry();
        String userQuery = StateUtils.getStringValue(state, "QUERY_REWRITE_NODE_OUTPUT");
        String pythonOutput = StateUtils.getStringValue(state, "PYTHON_EXECUTE_NODE_OUTPUT");
        int currentStep = this.getCurrentStepNumber(state);
        Map sqlExecuteResult = StateUtils.getObjectValue(state, "SQL_EXECUTE_NODE_OUTPUT", Map.class, new HashMap());
        String systemPrompt = PromptConstant.getPythonAnalyzePromptTemplate().render(Map.of("python_output", pythonOutput, "user_query", userQuery));
        Flux pythonAnalyzeFlux = this.chatClient.prompt().system(systemPrompt).stream().chatResponse();
        Flux<GraphResponse<StreamingOutput>> generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), state, "\u6b63\u5728\u5206\u6790\u4ee3\u7801\u8fd0\u884c\u7ed3\u679c...\n", "\n\u7ed3\u679c\u5206\u6790\u5b8c\u6210\u3002", aiResponse -> {
            Map<String, String> updatedSqlResult = StepResultUtils.addStepResult(sqlExecuteResult, currentStep, aiResponse);
            this.logNodeOutput("python_analysis_result", aiResponse);
            return Map.of("SQL_EXECUTE_NODE_OUTPUT", updatedSqlResult, "PLAN_CURRENT_STEP", currentStep + 1);
        }, (Flux<ChatResponse>)pythonAnalyzeFlux, StreamResponseType.PYTHON_ANALYSIS);
        return Map.of("PYTHON_ANALYSIS_NODE_OUTPUT", generator);
    }
}

