/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.config;

import com.alibaba.cloud.ai.connector.accessor.Accessor;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.service.LlmService;
import com.alibaba.cloud.ai.service.base.BaseNl2SqlService;
import com.alibaba.cloud.ai.service.base.BaseSchemaService;
import com.alibaba.cloud.ai.service.base.BaseVectorStoreService;
import com.alibaba.cloud.ai.service.simple.SimpleNl2SqlService;
import com.alibaba.cloud.ai.service.simple.SimpleSchemaService;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class BaseDefaultConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BaseDefaultConfiguration.class);
    private final Accessor dbAccessor;
    private final DbConfig dbConfig;

    private BaseDefaultConfiguration(DbConfig dbConfig, @Qualifier(value="mysqlAccessor") Accessor mysqlDbAccessor, @Qualifier(value="h2Accessor") Accessor h2DbAccessor, @Qualifier(value="postgreAccessor") Accessor postgreDbAccessor) {
        this.dbAccessor = "h2".equals(dbConfig.getDialectType()) ? h2DbAccessor : ("postgre".equals(dbConfig.getDialectType()) ? postgreDbAccessor : mysqlDbAccessor);
        this.dbConfig = dbConfig;
    }

    @Bean(value={"nl2SqlServiceImpl"})
    @ConditionalOnMissingBean(name={"nl2SqlServiceImpl"})
    public BaseNl2SqlService defaultNl2SqlService(@Qualifier(value="simpleVectorStoreService") BaseVectorStoreService vectorStoreService, @Qualifier(value="simpleSchemaService") BaseSchemaService schemaService, LlmService aiService) {
        logger.info("Creating default BaseNl2SqlService implementation");
        return new SimpleNl2SqlService(vectorStoreService, schemaService, aiService, this.dbAccessor, this.dbConfig);
    }

    @Bean(value={"schemaServiceImpl"})
    @ConditionalOnMissingBean(name={"schemaServiceImpl"})
    public BaseSchemaService defaultSchemaService(@Qualifier(value="simpleVectorStoreService") BaseVectorStoreService vectorStoreService, DbConfig dbConfig, Gson gson) {
        logger.info("Creating default BaseSchemaService implementation");
        return new SimpleSchemaService(dbConfig, gson, vectorStoreService);
    }

    @Bean(value={"dbAccessor"})
    @ConditionalOnMissingBean(name={"dbAccessor"})
    public Accessor dbAccessor() {
        return this.dbAccessor;
    }
}

