/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory.redis;

import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryProperties;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisMemoryConnectionDetails;
import java.util.List;

public class RedisChatMemoryConnectionDetails
implements RedisMemoryConnectionDetails {
    private final RedisChatMemoryProperties properties;

    public RedisChatMemoryConnectionDetails(RedisChatMemoryProperties properties) {
        this.properties = properties;
    }

    @Override
    public String getUsername() {
        return this.properties.getUsername();
    }

    @Override
    public String getPassword() {
        return this.properties.getPassword();
    }

    @Override
    public RedisMemoryConnectionDetails.Standalone getStandalone() {
        return RedisMemoryConnectionDetails.Standalone.of(this.properties.getHost(), this.properties.getPort());
    }

    @Override
    public RedisMemoryConnectionDetails.Cluster getCluster() {
        RedisChatMemoryProperties.Cluster cluster = this.properties.getCluster();
        List<RedisMemoryConnectionDetails.Node> nodes = cluster != null ? cluster.getNodes().stream().map(this::asNode).toList() : null;
        return nodes != null ? () -> nodes : null;
    }

    private RedisMemoryConnectionDetails.Node asNode(String node) {
        int portSeparatorIndex = node.lastIndexOf(58);
        String host = node.substring(0, portSeparatorIndex);
        int port = Integer.parseInt(node.substring(portSeparatorIndex + 1));
        return new RedisMemoryConnectionDetails.Node(host, port);
    }
}

