/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tools;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class GrepSearchTool
implements BiFunction<Request, ToolContext, String> {
    private final Path rootPath;
    private final boolean useRipgrep;
    private final long maxFileSizeBytes;

    public GrepSearchTool(String rootPath) {
        this(rootPath, true, 10);
    }

    public GrepSearchTool(String rootPath, boolean useRipgrep, int maxFileSizeMb) {
        this.rootPath = Paths.get(rootPath, new String[0]).toAbsolutePath().normalize();
        this.useRipgrep = useRipgrep;
        this.maxFileSizeBytes = (long)maxFileSizeMb * 1024L * 1024L;
    }

    @Override
    public String apply(Request request, ToolContext toolContext) {
        try {
            Pattern.compile(request.pattern());
        }
        catch (PatternSyntaxException e) {
            return "Invalid regex pattern: " + e.getMessage();
        }
        if (request.include() != null && !this.isValidIncludePattern(request.include())) {
            return "Invalid include pattern";
        }
        Map<String, List<MatchInfo>> results = null;
        if (this.useRipgrep) {
            try {
                results = this.ripgrepSearch(request.pattern(), request.path(), request.include());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (results == null) {
            results = this.javaSearch(request.pattern(), request.path(), request.include());
        }
        if (results.isEmpty()) {
            return "No matches found";
        }
        return this.formatResults(results, request.outputMode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<MatchInfo>> ripgrepSearch(String pattern, String basePath, String include) {
        try {
            Path baseFullPath = this.validateAndResolvePath(basePath);
            if (!Files.exists(baseFullPath, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("rg");
            cmd.add("--json");
            if (include != null && !include.isEmpty()) {
                cmd.add("--glob");
                cmd.add(include);
            }
            cmd.add("--");
            cmd.add(pattern);
            cmd.add(baseFullPath.toString());
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            HashMap results = new HashMap();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    try {
                        if (!line.contains("\"type\":\"match\"")) continue;
                        results.putIfAbsent("ripgrep_result", new ArrayList());
                    }
                    catch (Exception exception) {}
                }
            }
            boolean finished = process.waitFor(30L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                return null;
            }
            if (process.exitValue() != 0 && process.exitValue() != 1) {
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, List<MatchInfo>> javaSearch(String patternStr, String basePath, final String include) {
        try {
            Path baseFullPath = this.validateAndResolvePath(basePath);
            if (!Files.exists(baseFullPath, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            final Pattern pattern = Pattern.compile(patternStr);
            final LinkedHashMap<String, List<MatchInfo>> results = new LinkedHashMap<String, List<MatchInfo>>();
            Files.walkFileTree(baseFullPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (include != null && !GrepSearchTool.this.matchIncludePattern(file.getFileName().toString(), include)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (attrs.size() > GrepSearchTool.this.maxFileSizeBytes) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        String content = Files.readString(file, StandardCharsets.UTF_8);
                        String[] lines = content.split("\r?\n");
                        for (int i = 0; i < lines.length; ++i) {
                            Matcher matcher = pattern.matcher(lines[i]);
                            if (!matcher.find()) continue;
                            String virtualPath = "/" + GrepSearchTool.this.rootPath.relativize(file).toString().replace("\\", "/");
                            results.computeIfAbsent(virtualPath, k -> new ArrayList()).add(new MatchInfo(i + 1, lines[i]));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            return results;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private Path validateAndResolvePath(String path) throws IOException {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).contains("..") || ((String)path).contains("~")) {
            throw new IOException("Path traversal not allowed");
        }
        String relative = ((String)path).substring(1);
        Path fullPath = this.rootPath.resolve(relative).normalize();
        if (!fullPath.startsWith(this.rootPath)) {
            throw new IOException("Path outside root directory: " + (String)path);
        }
        return fullPath;
    }

    private boolean isValidIncludePattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return false;
        }
        return !pattern.contains("\u0000") && !pattern.contains("\n") && !pattern.contains("\r");
    }

    private boolean matchIncludePattern(String filename, String pattern) {
        String regex = pattern.replace(".", "\\.").replace("*", ".*").replace("?", ".");
        if (pattern.contains("{") && pattern.contains("}")) {
            regex = regex.replaceAll("\\{([^}]+)\\}", "($1)").replace(",", "|");
        }
        try {
            return filename.matches(regex);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    private String formatResults(Map<String, List<MatchInfo>> results, String outputMode) {
        return switch (outputMode) {
            case "files_with_matches" -> results.keySet().stream().sorted().collect(Collectors.joining("\n"));
            case "content" -> results.entrySet().stream().sorted(Map.Entry.comparingByKey()).flatMap(entry -> ((List)entry.getValue()).stream().map(info -> String.format("%s:%d:%s", entry.getKey(), info.lineNumber(), info.lineText()))).collect(Collectors.joining("\n"));
            case "count" -> results.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("%s:%d", entry.getKey(), ((List)entry.getValue()).size())).collect(Collectors.joining("\n"));
            default -> results.keySet().stream().sorted().collect(Collectors.joining("\n"));
        };
    }

    public static Builder builder(String rootPath) {
        return new Builder(rootPath);
    }

    public record Request(@JsonProperty(required=true) @JsonPropertyDescription(value="The regular expression pattern to search for in file contents") String pattern, @JsonProperty(defaultValue="/") @JsonPropertyDescription(value="The directory to search in. If not specified, searches from root.") String path, @JsonProperty @JsonPropertyDescription(value="File pattern to filter (e.g., \"*.js\", \"*.{ts,tsx}\")") String include, @JsonProperty(defaultValue="files_with_matches") @JsonPropertyDescription(value="Output format: files_with_matches (default), content, or count") String outputMode) {
        public Request {
            if (path == null || path.isEmpty()) {
                path = "/";
            }
            if (outputMode == null || outputMode.isEmpty()) {
                outputMode = "files_with_matches";
            }
        }
    }

    public static class Builder {
        private final String rootPath;
        private String name = "grep_search";
        private String description = "Fast content search tool that works with any codebase size. Searches file contents using regular expressions. Supports full regex syntax and filters files by pattern with the include parameter. Use this tool when you need to search for specific content within files.";
        private boolean useRipgrep = true;
        private int maxFileSizeMb = 10;

        public Builder(String rootPath) {
            this.rootPath = rootPath;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withUseRipgrep(boolean useRipgrep) {
            this.useRipgrep = useRipgrep;
            return this;
        }

        public Builder withMaxFileSizeMb(int maxFileSizeMb) {
            this.maxFileSizeMb = maxFileSizeMb;
            return this;
        }

        public ToolCallback build() {
            return FunctionToolCallback.builder((String)this.name, (BiFunction)new GrepSearchTool(this.rootPath, this.useRipgrep, this.maxFileSizeMb)).description(this.description).inputType(Request.class).build();
        }
    }

    private record MatchInfo(int lineNumber, String lineText) {
    }
}

