/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tools;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class GlobSearchTool
implements BiFunction<Request, ToolContext, String> {
    private final Path rootPath;

    public GlobSearchTool(String rootPath) {
        this.rootPath = Paths.get(rootPath, new String[0]).toAbsolutePath().normalize();
    }

    @Override
    public String apply(Request request, ToolContext toolContext) {
        try {
            final Path basePath = this.validateAndResolvePath(request.path());
            if (!Files.exists(basePath, new LinkOption[0]) || !Files.isDirectory(basePath, new LinkOption[0])) {
                return "No files found";
            }
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + request.pattern());
            final ArrayList<FileInfo> matchingFiles = new ArrayList<FileInfo>();
            Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Path relativePath = basePath.relativize(file);
                    if (matcher.matches(relativePath)) {
                        try {
                            String virtualPath = "/" + GlobSearchTool.this.rootPath.relativize(file).toString().replace("\\", "/");
                            Instant modifiedTime = attrs.lastModifiedTime().toInstant();
                            matchingFiles.add(new FileInfo(virtualPath, modifiedTime));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            if (matchingFiles.isEmpty()) {
                return "No files found";
            }
            matchingFiles.sort(Comparator.comparing(FileInfo::modifiedTime).reversed());
            return matchingFiles.stream().map(FileInfo::path).collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            return "No files found";
        }
    }

    private Path validateAndResolvePath(String path) throws IOException {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).contains("..") || ((String)path).contains("~")) {
            throw new IOException("Path traversal not allowed");
        }
        String relative = ((String)path).substring(1);
        Path fullPath = this.rootPath.resolve(relative).normalize();
        if (!fullPath.startsWith(this.rootPath)) {
            throw new IOException("Path outside root directory: " + (String)path);
        }
        return fullPath;
    }

    public static Builder builder(String rootPath) {
        return new Builder(rootPath);
    }

    public record Request(@JsonProperty(required=true) @JsonPropertyDescription(value="The glob pattern to match files against") String pattern, @JsonProperty(defaultValue="/") @JsonPropertyDescription(value="The directory to search in. If not specified, searches from root.") String path) {
        public Request {
            if (path == null || path.isEmpty()) {
                path = "/";
            }
        }
    }

    public static class Builder {
        private final String rootPath;
        private String name = "glob_search";
        private String description = "Fast file pattern matching tool that works with any codebase size. Supports glob patterns like **/*.js or src/**/*.ts. Returns matching file paths sorted by modification time. Use this tool when you need to find files by name patterns.";

        public Builder(String rootPath) {
            this.rootPath = rootPath;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public ToolCallback build() {
            return FunctionToolCallback.builder((String)this.name, (BiFunction)new GlobSearchTool(this.rootPath)).description(this.description).inputType(Request.class).build();
        }
    }

    private record FileInfo(String path, Instant modifiedTime) {
    }
}

