/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.KeyStrategyFactory;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.state.strategy.AppendStrategy;
import com.alibaba.cloud.ai.graph.state.strategy.ReplaceStrategy;
import java.util.HashMap;
import java.util.Map;

public interface FlowGraphBuildingStrategy {
    public StateGraph buildGraph(FlowGraphBuilder.FlowGraphConfig var1) throws GraphStateException;

    public String getStrategyType();

    default public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        if (config.getName() == null || config.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Graph name must be provided");
        }
        if (config.getRootAgent() == null) {
            throw new IllegalArgumentException("Root agent must be provided");
        }
        if (config.getKeyStrategyFactory() == null) {
            KeyStrategyFactory generatedFactory = this.generateKeyStrategyFactory(config);
            config.keyStrategyFactory(generatedFactory);
        }
    }

    default public KeyStrategyFactory generateKeyStrategyFactory(FlowGraphBuilder.FlowGraphConfig config) {
        return () -> {
            HashMap<String, KeyStrategy> keyStrategyMap = new HashMap<String, KeyStrategy>();
            ReplaceStrategy defaultStrategy = new ReplaceStrategy();
            if (config.getSubAgents() != null) {
                for (Agent subAgent : config.getSubAgents()) {
                    this.processAgentKeyStrategies(subAgent, keyStrategyMap, (KeyStrategy)defaultStrategy);
                }
            }
            keyStrategyMap.put("messages", (KeyStrategy)new AppendStrategy());
            return keyStrategyMap;
        };
    }

    default public void processAgentKeyStrategies(Agent agent, Map<String, KeyStrategy> keyStrategyMap, KeyStrategy defaultStrategy) {
        FlowAgent flowAgent;
        if (agent instanceof ReactAgent) {
            ReactAgent reactAgent = (ReactAgent)agent;
            this.processOutputKey(reactAgent.getOutputKey(), reactAgent.getOutputKeyStrategy(), keyStrategyMap, defaultStrategy);
        } else if (agent instanceof FlowAgent && (flowAgent = (FlowAgent)agent).subAgents() != null) {
            for (Agent subAgent : flowAgent.subAgents()) {
                this.processAgentKeyStrategies(subAgent, keyStrategyMap, defaultStrategy);
            }
        }
    }

    default public void processOutputKey(String outputKey, KeyStrategy outputKeyStrategy, Map<String, KeyStrategy> keyStrategyMap, KeyStrategy defaultStrategy) {
        if (outputKey != null) {
            if (outputKeyStrategy != null) {
                keyStrategyMap.put(outputKey, outputKeyStrategy);
            } else {
                keyStrategyMap.put(outputKey, defaultStrategy);
            }
        }
    }

    public static void addSubAgentNode(Agent subAgent, StateGraph newGraph) throws GraphStateException {
        if (subAgent instanceof FlowAgent) {
            FlowAgent flowAgent = (FlowAgent)subAgent;
            newGraph.addNode(flowAgent.name(), flowAgent.asStateGraph());
        } else if (subAgent instanceof BaseAgent) {
            BaseAgent baseAgent = (BaseAgent)subAgent;
            newGraph.addNode(baseAgent.name(), baseAgent.asNode(baseAgent.isIncludeContents(), baseAgent.isReturnReasoningContents(), baseAgent.getOutputKey()));
        } else {
            throw new IllegalArgumentException(subAgent.getClass().getName() + " only supports FlowAgent and BaseAgent types");
        }
    }
}

