/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowAgentBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import org.springframework.ai.chat.model.ChatModel;

public class LlmRoutingAgent
extends FlowAgent {
    private final ChatModel chatModel;

    protected LlmRoutingAgent(LlmRoutingAgentBuilder builder) throws GraphStateException {
        super(builder.name, builder.description, builder.compileConfig, builder.subAgents);
        this.chatModel = builder.chatModel;
    }

    public static LlmRoutingAgentBuilder builder() {
        return new LlmRoutingAgentBuilder();
    }

    @Override
    protected StateGraph buildSpecificGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        config.setChatModel(this.chatModel);
        return FlowGraphBuilder.buildGraph(FlowAgentEnum.ROUTING.getType(), config);
    }

    public static class LlmRoutingAgentBuilder
    extends FlowAgentBuilder<LlmRoutingAgent, LlmRoutingAgentBuilder> {
        private ChatModel chatModel;

        public LlmRoutingAgentBuilder model(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        @Override
        protected LlmRoutingAgentBuilder self() {
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.chatModel == null) {
                throw new IllegalArgumentException("ChatModel must be provided for LLM routing agent");
            }
        }

        @Override
        public LlmRoutingAgent build() throws GraphStateException {
            this.validate();
            return new LlmRoutingAgent(this);
        }
    }
}

