/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.file;

import com.alibaba.cloud.ai.graph.agent.extension.file.EditResult;
import com.alibaba.cloud.ai.graph.agent.extension.file.FileInfo;
import com.alibaba.cloud.ai.graph.agent.extension.file.FilesystemBackend;
import com.alibaba.cloud.ai.graph.agent.extension.file.GrepMatch;
import com.alibaba.cloud.ai.graph.agent.extension.file.WriteResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LocalFilesystemBackend
implements FilesystemBackend {
    private static final String EMPTY_CONTENT_WARNING = "System reminder: File exists but has empty contents";
    private static final int MAX_LINE_LENGTH = 10000;
    private static final int LINE_NUMBER_WIDTH = 6;
    private final Path cwd;
    private final boolean virtualMode;
    private final long maxFileSizeBytes;

    public LocalFilesystemBackend(String rootDir, boolean virtualMode, int maxFileSizeMb) {
        this.cwd = rootDir != null ? Paths.get(rootDir, new String[0]).toAbsolutePath().normalize() : Paths.get("", new String[0]).toAbsolutePath();
        this.virtualMode = virtualMode;
        this.maxFileSizeBytes = (long)maxFileSizeMb * 1024L * 1024L;
    }

    public LocalFilesystemBackend(String rootDir) {
        this(rootDir, false, 10);
    }

    private Path resolvePath(String key) throws IllegalArgumentException {
        if (this.virtualMode) {
            Object vpath;
            Object object = vpath = key.startsWith("/") ? key : "/" + key;
            if (((String)vpath).contains("..") || ((String)vpath).startsWith("~")) {
                throw new IllegalArgumentException("Path traversal not allowed");
            }
            Path full = this.cwd.resolve(((String)vpath).substring(1)).normalize();
            if (!full.startsWith(this.cwd)) {
                throw new IllegalArgumentException("Path:" + full + " outside root directory: " + this.cwd);
            }
            return full;
        }
        Path path = Paths.get(key, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        return this.cwd.resolve(path).normalize();
    }

    @Override
    public List<FileInfo> lsInfo(String path) {
        try {
            Path dirPath = this.resolvePath(path);
            if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            ArrayList<FileInfo> results = new ArrayList<FileInfo>();
            Object cwdStr = this.cwd.toString();
            if (!((String)cwdStr).endsWith("/")) {
                cwdStr = (String)cwdStr + "/";
            }
            try (Stream<Path> paths = Files.list(dirPath);){
                for (Path childPath : paths.collect(Collectors.toList())) {
                    try {
                        BasicFileAttributes attrs;
                        String relativePath;
                        boolean isFile = Files.isRegularFile(childPath, LinkOption.NOFOLLOW_LINKS);
                        boolean isDir = Files.isDirectory(childPath, LinkOption.NOFOLLOW_LINKS);
                        String absPath = childPath.toString();
                        if (!this.virtualMode) {
                            BasicFileAttributes attrs2;
                            if (isFile) {
                                try {
                                    attrs2 = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                                    results.add(new FileInfo(absPath, false, attrs2.size(), this.formatTimestamp(attrs2.lastModifiedTime().toInstant())));
                                }
                                catch (IOException e) {
                                    results.add(new FileInfo(absPath, false, null, null));
                                }
                                continue;
                            }
                            if (!isDir) continue;
                            try {
                                attrs2 = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                                results.add(new FileInfo(absPath + "/", true, 0L, this.formatTimestamp(attrs2.lastModifiedTime().toInstant())));
                            }
                            catch (IOException e) {
                                results.add(new FileInfo(absPath + "/", true, null, null));
                            }
                            continue;
                        }
                        if (absPath.startsWith((String)cwdStr)) {
                            relativePath = absPath.substring(((String)cwdStr).length());
                        } else if (absPath.startsWith(this.cwd.toString())) {
                            relativePath = absPath.substring(this.cwd.toString().length());
                            if (relativePath.startsWith("/")) {
                                relativePath = relativePath.substring(1);
                            }
                        } else {
                            relativePath = absPath;
                        }
                        String virtPath = "/" + relativePath;
                        if (isFile) {
                            try {
                                attrs = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                                results.add(new FileInfo(virtPath, false, attrs.size(), this.formatTimestamp(attrs.lastModifiedTime().toInstant())));
                            }
                            catch (IOException e) {
                                results.add(new FileInfo(virtPath, false, null, null));
                            }
                            continue;
                        }
                        if (!isDir) continue;
                        try {
                            attrs = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                            results.add(new FileInfo(virtPath + "/", true, 0L, this.formatTimestamp(attrs.lastModifiedTime().toInstant())));
                        }
                        catch (IOException e) {
                            results.add(new FileInfo(virtPath + "/", true, null, null));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            results.sort(Comparator.comparing(FileInfo::getPath));
            return results;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public String read(String filePath, int offset, int limit) {
        try {
            Path resolvedPath = this.resolvePath(filePath);
            if (!Files.exists(resolvedPath, new LinkOption[0]) || !Files.isRegularFile(resolvedPath, LinkOption.NOFOLLOW_LINKS)) {
                return "Error: File '" + filePath + "' not found";
            }
            String content = new String(Files.readAllBytes(resolvedPath), StandardCharsets.UTF_8);
            String emptyMsg = this.checkEmptyContent(content);
            if (emptyMsg != null) {
                return emptyMsg;
            }
            String[] lines = content.split("\n", -1);
            if (lines.length > 0 && lines[lines.length - 1].isEmpty()) {
                lines = Arrays.copyOf(lines, lines.length - 1);
            }
            int startIdx = offset;
            int endIdx = Math.min(startIdx + limit, lines.length);
            if (startIdx >= lines.length) {
                return "Error: Line offset " + offset + " exceeds file length (" + lines.length + " lines)";
            }
            String[] selectedLines = Arrays.copyOfRange(lines, startIdx, endIdx);
            return this.formatContentWithLineNumbers(selectedLines, startIdx + 1);
        }
        catch (IllegalArgumentException e) {
            return "Error: " + e.getMessage();
        }
        catch (IOException e) {
            return "Error reading file '" + filePath + "': " + e.getMessage();
        }
    }

    @Override
    public WriteResult write(String filePath, String content) {
        try {
            Path resolvedPath = this.resolvePath(filePath);
            if (Files.exists(resolvedPath, new LinkOption[0])) {
                return new WriteResult(null, "Cannot write to " + filePath + " because it already exists. Read and then make an edit, or write to a new path.", null);
            }
            Path parent = resolvedPath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(resolvedPath, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            return new WriteResult(filePath, null, null);
        }
        catch (IllegalArgumentException e) {
            return new WriteResult(null, "Error: " + e.getMessage(), null);
        }
        catch (IOException e) {
            return new WriteResult(null, "Error writing file '" + filePath + "': " + e.getMessage(), null);
        }
    }

    @Override
    public EditResult edit(String filePath, String oldString, String newString, boolean replaceAll) {
        try {
            Path resolvedPath = this.resolvePath(filePath);
            if (!Files.exists(resolvedPath, new LinkOption[0]) || !Files.isRegularFile(resolvedPath, LinkOption.NOFOLLOW_LINKS)) {
                return new EditResult(null, 0, "Error: File '" + filePath + "' not found", null);
            }
            String content = new String(Files.readAllBytes(resolvedPath), StandardCharsets.UTF_8);
            int occurrences = this.countOccurrences(content, oldString);
            if (occurrences == 0) {
                return new EditResult(null, 0, "Error: String not found in file: '" + oldString + "'", null);
            }
            if (occurrences > 1 && !replaceAll) {
                return new EditResult(null, 0, "Error: String '" + oldString + "' appears " + occurrences + " times in file. Use replaceAll=true to replace all instances, or provide a more specific string with surrounding context.", null);
            }
            String newContent = content.replace(oldString, newString);
            Files.write(resolvedPath, newContent.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            return new EditResult(filePath, occurrences, null, null);
        }
        catch (IllegalArgumentException e) {
            return new EditResult(null, 0, "Error: " + e.getMessage(), null);
        }
        catch (IOException e) {
            return new EditResult(null, 0, "Error editing file '" + filePath + "': " + e.getMessage(), null);
        }
    }

    @Override
    public List<FileInfo> globInfo(String pattern, String path) {
        try {
            Path searchPath;
            if (pattern.startsWith("/")) {
                pattern = pattern.substring(1);
            }
            Path path2 = searchPath = "/".equals(path) ? this.cwd : this.resolvePath(path);
            if (!Files.exists(searchPath, new LinkOption[0]) || !Files.isDirectory(searchPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            final ArrayList<FileInfo> results = new ArrayList<FileInfo>();
            String globPattern = pattern;
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + globPattern);
            final String cwdStr = this.cwd.toString() + (this.cwd.toString().endsWith("/") ? "" : "/");
            Files.walkFileTree(searchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        if (!attrs.isRegularFile()) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path relativePath = searchPath.relativize(file);
                        if (matcher.matches(relativePath)) {
                            String absPath = file.toString();
                            if (!LocalFilesystemBackend.this.virtualMode) {
                                try {
                                    results.add(new FileInfo(absPath, false, attrs.size(), LocalFilesystemBackend.this.formatTimestamp(attrs.lastModifiedTime().toInstant())));
                                }
                                catch (Exception e) {
                                    results.add(new FileInfo(absPath, false, null, null));
                                }
                            } else {
                                String relPath;
                                if (absPath.startsWith(cwdStr)) {
                                    relPath = absPath.substring(cwdStr.length());
                                } else if (absPath.startsWith(LocalFilesystemBackend.this.cwd.toString())) {
                                    relPath = absPath.substring(LocalFilesystemBackend.this.cwd.toString().length());
                                    if (relPath.startsWith("/")) {
                                        relPath = relPath.substring(1);
                                    }
                                } else {
                                    relPath = absPath;
                                }
                                String virt = "/" + relPath;
                                try {
                                    results.add(new FileInfo(virt, false, attrs.size(), LocalFilesystemBackend.this.formatTimestamp(attrs.lastModifiedTime().toInstant())));
                                }
                                catch (Exception e) {
                                    results.add(new FileInfo(virt, false, null, null));
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            results.sort(Comparator.comparing(FileInfo::getPath));
            return results;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public Object grepRaw(String pattern, String path, String glob) {
        Path baseFull;
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return "Invalid regex pattern: " + e.getMessage();
        }
        try {
            baseFull = this.resolvePath(path != null ? path : ".");
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
        if (!Files.exists(baseFull, new LinkOption[0])) {
            return Collections.emptyList();
        }
        Map<String, List<LineMatch>> results = this.ripgrepSearch(pattern, baseFull, glob);
        if (results == null) {
            results = this.javaSearch(pattern, baseFull, glob);
        }
        ArrayList<GrepMatch> matches = new ArrayList<GrepMatch>();
        for (Map.Entry<String, List<LineMatch>> entry : results.entrySet()) {
            for (LineMatch lm : entry.getValue()) {
                matches.add(new GrepMatch(entry.getKey(), lm.lineNum, lm.lineText));
            }
        }
        return matches;
    }

    private Map<String, List<LineMatch>> ripgrepSearch(String pattern, Path baseFull, String includeGlob) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("rg");
        cmd.add("--json");
        if (includeGlob != null) {
            cmd.add("--glob");
            cmd.add(includeGlob);
        }
        cmd.add("--");
        cmd.add(pattern);
        cmd.add(baseFull.toString());
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process process = pb.start();
            HashMap<String, List<LineMatch>> results = new HashMap<String, List<LineMatch>>();
            ObjectMapper mapper = new ObjectMapper();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    try {
                        Integer ln;
                        Object virt;
                        JsonNode pdata;
                        block15: {
                            String ftext;
                            JsonNode data = mapper.readTree(line);
                            if (!"match".equals(data.path("type").asText()) || (ftext = (pdata = data.path("data")).path("path").path("text").asText(null)) == null) continue;
                            Path p = Paths.get(ftext, new String[0]);
                            if (this.virtualMode) {
                                try {
                                    Path resolved = p.toAbsolutePath().normalize();
                                    Path relative = this.cwd.relativize(resolved);
                                    virt = "/" + relative.toString().replace("\\", "/");
                                    break block15;
                                }
                                catch (Exception e) {
                                    continue;
                                }
                            }
                            virt = p.toString();
                        }
                        if ((ln = Integer.valueOf(pdata.path("line_number").asInt(0))) == 0) continue;
                        String lt = pdata.path("lines").path("text").asText("");
                        if (lt.endsWith("\n")) {
                            lt = lt.substring(0, lt.length() - 1);
                        }
                        results.computeIfAbsent((String)virt, k -> new ArrayList()).add(new LineMatch(ln, lt));
                    }
                    catch (Exception exception) {}
                }
            }
            process.waitFor();
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, List<LineMatch>> javaSearch(String pattern, Path baseFull, final String includeGlob) {
        Pattern regex;
        try {
            regex = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return Collections.emptyMap();
        }
        final HashMap<String, List<LineMatch>> results = new HashMap<String, List<LineMatch>>();
        Path root = Files.isDirectory(baseFull, new LinkOption[0]) ? baseFull : baseFull.getParent();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path fp, BasicFileAttributes attrs) {
                    PathMatcher matcher;
                    if (!attrs.isRegularFile()) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (includeGlob != null && !(matcher = FileSystems.getDefault().getPathMatcher("glob:" + includeGlob)).matches(fp.getFileName())) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        if (attrs.size() > LocalFilesystemBackend.this.maxFileSizeBytes) {
                            return FileVisitResult.CONTINUE;
                        }
                        String content = new String(Files.readAllBytes(fp), StandardCharsets.UTF_8);
                        String[] lines = content.split("\n", -1);
                        for (int lineNum = 1; lineNum <= lines.length; ++lineNum) {
                            Object virtPath;
                            String line;
                            block9: {
                                line = lines[lineNum - 1];
                                Matcher m = regex.matcher(line);
                                if (!m.find()) continue;
                                if (LocalFilesystemBackend.this.virtualMode) {
                                    try {
                                        Path resolved = fp.toAbsolutePath().normalize();
                                        Path relative = LocalFilesystemBackend.this.cwd.relativize(resolved);
                                        virtPath = "/" + relative.toString().replace("\\", "/");
                                        break block9;
                                    }
                                    catch (Exception e) {
                                        continue;
                                    }
                                }
                                virtPath = fp.toString();
                            }
                            results.computeIfAbsent(virtPath, k -> new ArrayList()).add(new LineMatch(lineNum, line));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return results;
    }

    private String formatContentWithLineNumbers(String[] lines, int startLine) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int lineNum = i + startLine;
            if (line.length() <= 10000) {
                result.append(String.format("%6d\t%s\n", lineNum, line));
                continue;
            }
            int numChunks = (line.length() + 10000 - 1) / 10000;
            for (int chunkIdx = 0; chunkIdx < numChunks; ++chunkIdx) {
                int start = chunkIdx * 10000;
                int end = Math.min(start + 10000, line.length());
                String chunk = line.substring(start, end);
                if (chunkIdx == 0) {
                    result.append(String.format("%6d\t%s\n", lineNum, chunk));
                    continue;
                }
                String continuationMarker = lineNum + "." + chunkIdx;
                result.append(String.format("%6s\t%s\n", continuationMarker, chunk));
            }
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == '\n') {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    private String checkEmptyContent(String content) {
        if (content == null || content.trim().isEmpty()) {
            return EMPTY_CONTENT_WARNING;
        }
        return null;
    }

    private int countOccurrences(String content, String search) {
        int count = 0;
        int index = 0;
        while ((index = content.indexOf(search, index)) != -1) {
            ++count;
            index += search.length();
        }
        return count;
    }

    private String formatTimestamp(Instant instant) {
        return instant.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private static class LineMatch {
        final int lineNum;
        final String lineText;

        LineMatch(int lineNum, String lineText) {
            this.lineNum = lineNum;
            this.lineText = lineText;
        }
    }
}

