/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.a2a;

import com.alibaba.cloud.ai.graph.agent.a2a.AgentCardProvider;
import com.alibaba.cloud.ai.graph.agent.a2a.AgentCardWrapper;
import io.a2a.A2A;
import io.a2a.spec.AgentCard;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAgentCardProvider
implements AgentCardProvider {
    private static final Logger logger = LoggerFactory.getLogger(AgentCard.class);
    private final String url;
    private AgentCard agentCard;

    private RemoteAgentCardProvider(String url) {
        this.url = url;
    }

    public static AgentCardProvider newProvider(String url) {
        return new RemoteAgentCardProvider(url);
    }

    @Override
    public AgentCardWrapper getAgentCard() {
        if (null == this.agentCard) {
            this.agentCard = this.getAgentCardFromUrl();
        }
        return new AgentCardWrapper(this.agentCard);
    }

    private AgentCard getAgentCardFromUrl() {
        try {
            AgentCard publicAgentCard;
            AgentCard finalAgentCard = publicAgentCard = A2A.getAgentCard((String)this.url);
            if (publicAgentCard.supportsAuthenticatedExtendedCard()) {
                HashMap<String, String> authHeaders = new HashMap<String, String>();
                authHeaders.put("Authorization", "Bearer dummy-token-for-extended-card");
                finalAgentCard = A2A.getAgentCard((String)this.url, (String)"/agent/authenticatedExtendedCard", authHeaders);
            } else {
                logger.info("Public card does not indicate support for an extended card. Using public card.");
            }
            return finalAgentCard;
        }
        catch (Exception e) {
            logger.error("Error building agent card", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

