/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.tool.execution.ToolCallResultConverter;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class MessageToolCallResultConverter
implements ToolCallResultConverter {
    private static final Logger logger = LoggerFactory.getLogger(MessageToolCallResultConverter.class);

    public String convert(@Nullable Object result, @Nullable Type returnType) {
        if (returnType == Void.TYPE) {
            logger.debug("The tool has no return type. Converting to conventional response.");
            return JsonParser.toJson((Object)"Done");
        }
        if (result instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)result;
            if (StringUtils.hasLength((String)assistantMessage.getText())) {
                return assistantMessage.getText();
            }
            if (CollectionUtils.isNotEmpty((Collection)assistantMessage.getMedia())) {
                throw new UnsupportedOperationException("Currently Spring AI ToolResponseMessage only supports text type, that's why the return type of this method is String. More types like image/audio/video/file can be supported in the future.");
            }
            logger.warn("The tool returned an empty AssistantMessage. Converting to conventional response.");
            return JsonParser.toJson((Object)"Done");
        }
        logger.debug("Converting tool result to JSON.");
        return JsonParser.toJson((Object)result);
    }
}

