/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.tools;

import com.alibaba.boot.velocity.tools.VelocityTool;
import com.alibaba.boot.velocity.tools.VelocityToolsScanner;
import com.alibaba.boot.velocity.util.CompatibleRelaxedPropertyResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public abstract class AbstractVelocityToolsScanner
implements VelocityToolsScanner {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CompatibleRelaxedPropertyResolver propertyResolver;

    @Override
    public final Map<String, VelocityTool> scan() {
        HashMap<String, VelocityTool> velocityToolsMap = new HashMap<String, VelocityTool>();
        String[] sources = this.resolveSources();
        this.scan(sources, velocityToolsMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(this.getClass().getSimpleName() + " scanned " + velocityToolsMap.size() + " velocity tools [" + velocityToolsMap.values() + "] from sources[" + Arrays.asList(sources) + "]"));
        }
        return Collections.unmodifiableMap(velocityToolsMap);
    }

    protected abstract String[] resolveSources();

    protected String[] resolveRelaxedPropertyAsStringArray(String propertyName) {
        return this.propertyResolver.getProperty(propertyName, String[].class, new String[0]);
    }

    protected abstract void scan(String[] var1, Map<String, VelocityTool> var2);

    public void setEnvironment(Environment environment) {
        this.propertyResolver = new CompatibleRelaxedPropertyResolver((PropertyResolver)environment);
    }
}

