/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.oracle;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.oracle.model.OracleColumnModel;
import cn.smallbun.screw.core.query.oracle.model.OracleDatabaseModel;
import cn.smallbun.screw.core.query.oracle.model.OraclePrimaryKeyModel;
import cn.smallbun.screw.core.query.oracle.model.OracleTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.CollectionUtils;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class OracleDataBaseQuery
extends AbstractDatabaseQuery {
    private final Map<String, List<Column>> columnsCaching = new ConcurrentHashMap<String, List<Column>>();

    public OracleDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        OracleDatabaseModel model = new OracleDatabaseModel();
        model.setDatabase(this.getSchema());
        return model;
    }

    public List<OracleTableModel> getTables() throws QueryException {
        List<OracleTableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            List<OracleTableModel> list2 = Mapping.convertList(resultSet, OracleTableModel.class);
            String sql = "SELECT TABLE_NAME,COMMENTS AS REMARKS FROM USER_TAB_COMMENTS WHERE TABLE_TYPE = 'TABLE'";
            resultSet = this.prepareStatement(String.format(sql, this.getSchema())).executeQuery();
            List<OracleTableModel> inquires = Mapping.convertList(resultSet, OracleTableModel.class);
            list2.forEach(model -> inquires.stream().filter(inquire -> model.getTableName().equals(inquire.getTableName())).forEachOrdered(inquire -> model.setRemarks(inquire.getRemarks())));
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    public List<OracleColumnModel> getTableColumns(String table) throws QueryException {
        List<OracleColumnModel> list;
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<OracleColumnModel> list2 = Mapping.convertList(resultSet, OracleColumnModel.class);
            List<String> tableNames = list2.stream().map(OracleColumnModel::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(this.columnsCaching)) {
                String sql;
                if (table.equals("%")) {
                    sql = "SELECT TABLE_NAME, COLUMN_NAME, COMMENTS AS REMARKS FROM USER_COL_COMMENTS";
                    PreparedStatement statement = this.prepareStatement(sql);
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT TABLE_NAME, COLUMN_NAME, COMMENTS AS REMARKS FROM USER_COL_COMMENTS WHERE TABLE_NAME = '%s'";
                    resultSet = this.prepareStatement(String.format(sql, table)).executeQuery();
                }
                List<OracleColumnModel> inquires = Mapping.convertList(resultSet, OracleColumnModel.class);
                tableNames.forEach(name -> this.columnsCaching.put((String)name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            for (OracleColumnModel i : list2) {
                List<Column> columns = this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setRemarks(j.getRemarks());
                    }
                });
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List<OraclePrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, OraclePrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<OraclePrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT NULL AS TABLE_CAT, C.OWNER AS TABLE_SCHEM, C.TABLE_NAME, C.COLUMN_NAME, C.POSITION AS KEY_SEQ, C.CONSTRAINT_NAME AS PK_NAME FROM ALL_CONS_COLUMNS C, ALL_CONSTRAINTS K WHERE K.CONSTRAINT_TYPE = 'P' AND K.OWNER LIKE '%s' ESCAPE '/' AND K.CONSTRAINT_NAME = C.CONSTRAINT_NAME AND K.TABLE_NAME = C.TABLE_NAME AND K.OWNER = C.OWNER ORDER BY COLUMN_NAME ";
            resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase())).executeQuery();
            list = Mapping.convertList(resultSet, OraclePrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }
}

