/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.metadata.holder;

import cn.idev.excel.enums.HolderEnum;
import cn.idev.excel.enums.WriteLastRowTypeEnum;
import cn.idev.excel.util.StringUtils;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.holder.AbstractWriteHolder;
import cn.idev.excel.write.metadata.holder.WriteTableHolder;
import cn.idev.excel.write.metadata.holder.WriteWorkbookHolder;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class WriteSheetHolder
extends AbstractWriteHolder {
    private WriteSheet writeSheet;
    private Sheet sheet;
    private Sheet cachedSheet;
    private Integer sheetNo;
    private String sheetName;
    private WriteWorkbookHolder parentWriteWorkbookHolder;
    private Map<Integer, WriteTableHolder> hasBeenInitializedTable;
    private WriteLastRowTypeEnum writeLastRowTypeEnum;
    private Integer lastRowIndex;

    public WriteSheetHolder(WriteSheet writeSheet, WriteWorkbookHolder writeWorkbookHolder) {
        super(writeSheet, writeWorkbookHolder);
        this.initHandler(writeSheet, writeWorkbookHolder);
        this.writeSheet = writeSheet;
        this.sheetNo = writeSheet.getSheetNo() == null && StringUtils.isEmpty(writeSheet.getSheetName()) ? Integer.valueOf(0) : writeSheet.getSheetNo();
        this.sheetName = writeSheet.getSheetName();
        this.parentWriteWorkbookHolder = writeWorkbookHolder;
        this.hasBeenInitializedTable = new HashMap<Integer, WriteTableHolder>();
        this.writeLastRowTypeEnum = writeWorkbookHolder.getTempTemplateInputStream() != null ? WriteLastRowTypeEnum.TEMPLATE_EMPTY : WriteLastRowTypeEnum.COMMON_EMPTY;
        this.lastRowIndex = 0;
    }

    public int getNewRowIndexAndStartDoWrite() {
        int newRowIndex = 0;
        switch (this.writeLastRowTypeEnum) {
            case TEMPLATE_EMPTY: {
                newRowIndex = Math.max(this.sheet.getLastRowNum(), this.cachedSheet.getLastRowNum());
                if (newRowIndex == 0 && this.cachedSheet.getRow(0) == null) break;
                ++newRowIndex;
                break;
            }
            case HAS_DATA: {
                newRowIndex = Math.max(this.sheet.getLastRowNum(), this.cachedSheet.getLastRowNum());
                ++newRowIndex;
                break;
            }
        }
        this.writeLastRowTypeEnum = WriteLastRowTypeEnum.HAS_DATA;
        return newRowIndex;
    }

    @Override
    public HolderEnum holderType() {
        return HolderEnum.SHEET;
    }

    public WriteSheet getWriteSheet() {
        return this.writeSheet;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Sheet getCachedSheet() {
        return this.cachedSheet;
    }

    public Integer getSheetNo() {
        return this.sheetNo;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public WriteWorkbookHolder getParentWriteWorkbookHolder() {
        return this.parentWriteWorkbookHolder;
    }

    public Map<Integer, WriteTableHolder> getHasBeenInitializedTable() {
        return this.hasBeenInitializedTable;
    }

    public WriteLastRowTypeEnum getWriteLastRowTypeEnum() {
        return this.writeLastRowTypeEnum;
    }

    public Integer getLastRowIndex() {
        return this.lastRowIndex;
    }

    public void setWriteSheet(WriteSheet writeSheet) {
        this.writeSheet = writeSheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setCachedSheet(Sheet cachedSheet) {
        this.cachedSheet = cachedSheet;
    }

    public void setSheetNo(Integer sheetNo) {
        this.sheetNo = sheetNo;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setParentWriteWorkbookHolder(WriteWorkbookHolder parentWriteWorkbookHolder) {
        this.parentWriteWorkbookHolder = parentWriteWorkbookHolder;
    }

    public void setHasBeenInitializedTable(Map<Integer, WriteTableHolder> hasBeenInitializedTable) {
        this.hasBeenInitializedTable = hasBeenInitializedTable;
    }

    public void setWriteLastRowTypeEnum(WriteLastRowTypeEnum writeLastRowTypeEnum) {
        this.writeLastRowTypeEnum = writeLastRowTypeEnum;
    }

    public void setLastRowIndex(Integer lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteSheetHolder)) {
            return false;
        }
        WriteSheetHolder other = (WriteSheetHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sheetNo = this.getSheetNo();
        Integer other$sheetNo = other.getSheetNo();
        if (this$sheetNo == null ? other$sheetNo != null : !((Object)this$sheetNo).equals(other$sheetNo)) {
            return false;
        }
        Integer this$lastRowIndex = this.getLastRowIndex();
        Integer other$lastRowIndex = other.getLastRowIndex();
        if (this$lastRowIndex == null ? other$lastRowIndex != null : !((Object)this$lastRowIndex).equals(other$lastRowIndex)) {
            return false;
        }
        WriteSheet this$writeSheet = this.getWriteSheet();
        WriteSheet other$writeSheet = other.getWriteSheet();
        if (this$writeSheet == null ? other$writeSheet != null : !((Object)this$writeSheet).equals(other$writeSheet)) {
            return false;
        }
        Sheet this$sheet = this.getSheet();
        Sheet other$sheet = other.getSheet();
        if (this$sheet == null ? other$sheet != null : !this$sheet.equals(other$sheet)) {
            return false;
        }
        Sheet this$cachedSheet = this.getCachedSheet();
        Sheet other$cachedSheet = other.getCachedSheet();
        if (this$cachedSheet == null ? other$cachedSheet != null : !this$cachedSheet.equals(other$cachedSheet)) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
            return false;
        }
        WriteWorkbookHolder this$parentWriteWorkbookHolder = this.getParentWriteWorkbookHolder();
        WriteWorkbookHolder other$parentWriteWorkbookHolder = other.getParentWriteWorkbookHolder();
        if (this$parentWriteWorkbookHolder == null ? other$parentWriteWorkbookHolder != null : !((Object)this$parentWriteWorkbookHolder).equals(other$parentWriteWorkbookHolder)) {
            return false;
        }
        Map<Integer, WriteTableHolder> this$hasBeenInitializedTable = this.getHasBeenInitializedTable();
        Map<Integer, WriteTableHolder> other$hasBeenInitializedTable = other.getHasBeenInitializedTable();
        if (this$hasBeenInitializedTable == null ? other$hasBeenInitializedTable != null : !((Object)this$hasBeenInitializedTable).equals(other$hasBeenInitializedTable)) {
            return false;
        }
        WriteLastRowTypeEnum this$writeLastRowTypeEnum = this.getWriteLastRowTypeEnum();
        WriteLastRowTypeEnum other$writeLastRowTypeEnum = other.getWriteLastRowTypeEnum();
        return !(this$writeLastRowTypeEnum == null ? other$writeLastRowTypeEnum != null : !((Object)((Object)this$writeLastRowTypeEnum)).equals((Object)other$writeLastRowTypeEnum));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WriteSheetHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sheetNo = this.getSheetNo();
        result = result * 59 + ($sheetNo == null ? 43 : ((Object)$sheetNo).hashCode());
        Integer $lastRowIndex = this.getLastRowIndex();
        result = result * 59 + ($lastRowIndex == null ? 43 : ((Object)$lastRowIndex).hashCode());
        WriteSheet $writeSheet = this.getWriteSheet();
        result = result * 59 + ($writeSheet == null ? 43 : ((Object)$writeSheet).hashCode());
        Sheet $sheet = this.getSheet();
        result = result * 59 + ($sheet == null ? 43 : $sheet.hashCode());
        Sheet $cachedSheet = this.getCachedSheet();
        result = result * 59 + ($cachedSheet == null ? 43 : $cachedSheet.hashCode());
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        WriteWorkbookHolder $parentWriteWorkbookHolder = this.getParentWriteWorkbookHolder();
        result = result * 59 + ($parentWriteWorkbookHolder == null ? 43 : ((Object)$parentWriteWorkbookHolder).hashCode());
        Map<Integer, WriteTableHolder> $hasBeenInitializedTable = this.getHasBeenInitializedTable();
        result = result * 59 + ($hasBeenInitializedTable == null ? 43 : ((Object)$hasBeenInitializedTable).hashCode());
        WriteLastRowTypeEnum $writeLastRowTypeEnum = this.getWriteLastRowTypeEnum();
        result = result * 59 + ($writeLastRowTypeEnum == null ? 43 : ((Object)((Object)$writeLastRowTypeEnum)).hashCode());
        return result;
    }

    public WriteSheetHolder() {
    }
}

