/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.context;

import cn.idev.excel.context.WriteContext;
import cn.idev.excel.enums.WriteTypeEnum;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.metadata.CellRange;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.idev.excel.support.ExcelTypeEnum;
import cn.idev.excel.util.ClassUtils;
import cn.idev.excel.util.DateUtils;
import cn.idev.excel.util.FileUtils;
import cn.idev.excel.util.ListUtils;
import cn.idev.excel.util.NumberDataFormatterUtils;
import cn.idev.excel.util.StringUtils;
import cn.idev.excel.util.WorkBookUtil;
import cn.idev.excel.util.WriteHandlerUtils;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.handler.context.RowWriteHandlerContext;
import cn.idev.excel.write.handler.context.SheetWriteHandlerContext;
import cn.idev.excel.write.handler.context.WorkbookWriteHandlerContext;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.WriteTable;
import cn.idev.excel.write.metadata.WriteWorkbook;
import cn.idev.excel.write.metadata.holder.WriteHolder;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import cn.idev.excel.write.metadata.holder.WriteTableHolder;
import cn.idev.excel.write.metadata.holder.WriteWorkbookHolder;
import cn.idev.excel.write.property.ExcelWriteHeadProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteContextImpl
implements WriteContext {
    private static final Logger log = LoggerFactory.getLogger(WriteContextImpl.class);
    private static final String NO_SHEETS = "no sheets";
    private WriteWorkbookHolder writeWorkbookHolder;
    private WriteSheetHolder writeSheetHolder;
    private WriteTableHolder writeTableHolder;
    private WriteHolder currentWriteHolder;
    private boolean finished = false;

    public WriteContextImpl(WriteWorkbook writeWorkbook) {
        if (writeWorkbook == null) {
            throw new IllegalArgumentException("Workbook argument cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Begin to Initialization 'WriteContextImpl'");
        }
        this.initCurrentWorkbookHolder(writeWorkbook);
        WorkbookWriteHandlerContext workbookWriteHandlerContext = WriteHandlerUtils.createWorkbookWriteHandlerContext(this);
        WriteHandlerUtils.beforeWorkbookCreate(workbookWriteHandlerContext);
        try {
            WorkBookUtil.createWorkBook(this.writeWorkbookHolder);
        }
        catch (Exception e) {
            throw new ExcelGenerateException("Create workbook failure", e);
        }
        WriteHandlerUtils.afterWorkbookCreate(workbookWriteHandlerContext);
        if (log.isDebugEnabled()) {
            log.debug("Initialization 'WriteContextImpl' complete");
        }
    }

    private void initCurrentWorkbookHolder(WriteWorkbook writeWorkbook) {
        this.writeWorkbookHolder = new WriteWorkbookHolder(writeWorkbook);
        this.currentWriteHolder = this.writeWorkbookHolder;
        if (log.isDebugEnabled()) {
            log.debug("CurrentConfiguration is writeWorkbookHolder");
        }
    }

    @Override
    public void currentSheet(WriteSheet writeSheet, WriteTypeEnum writeType) {
        if (writeSheet == null) {
            throw new IllegalArgumentException("Sheet argument cannot be null");
        }
        if (this.selectSheetFromCache(writeSheet)) {
            return;
        }
        this.initCurrentSheetHolder(writeSheet);
        WorkbookWriteHandlerContext workbookWriteHandlerContext = WriteHandlerUtils.createWorkbookWriteHandlerContext(this);
        WriteHandlerUtils.beforeWorkbookCreate(workbookWriteHandlerContext, true);
        WriteHandlerUtils.afterWorkbookCreate(workbookWriteHandlerContext, true);
        this.initSheet(writeType);
    }

    private boolean selectSheetFromCache(WriteSheet writeSheet) {
        this.writeSheetHolder = null;
        Integer sheetNo = writeSheet.getSheetNo();
        if (sheetNo == null && StringUtils.isEmpty(writeSheet.getSheetName())) {
            sheetNo = 0;
        }
        if (sheetNo != null) {
            this.writeSheetHolder = this.writeWorkbookHolder.getHasBeenInitializedSheetIndexMap().get(sheetNo);
        }
        if (this.writeSheetHolder == null && !StringUtils.isEmpty(writeSheet.getSheetName())) {
            this.writeSheetHolder = this.writeWorkbookHolder.getHasBeenInitializedSheetNameMap().get(writeSheet.getSheetName());
        }
        if (this.writeSheetHolder == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Sheet:{},{} is already existed", (Object)writeSheet.getSheetNo(), (Object)writeSheet.getSheetName());
        }
        this.writeSheetHolder.setNewInitialization(Boolean.FALSE);
        this.writeTableHolder = null;
        this.currentWriteHolder = this.writeSheetHolder;
        if (log.isDebugEnabled()) {
            log.debug("CurrentConfiguration is writeSheetHolder");
        }
        return true;
    }

    private void initCurrentSheetHolder(WriteSheet writeSheet) {
        this.writeSheetHolder = new WriteSheetHolder(writeSheet, this.writeWorkbookHolder);
        this.writeTableHolder = null;
        this.currentWriteHolder = this.writeSheetHolder;
        if (log.isDebugEnabled()) {
            log.debug("CurrentConfiguration is writeSheetHolder");
        }
    }

    private void initSheet(WriteTypeEnum writeType) {
        Sheet currentSheet;
        SheetWriteHandlerContext sheetWriteHandlerContext = WriteHandlerUtils.createSheetWriteHandlerContext(this);
        WriteHandlerUtils.beforeSheetCreate(sheetWriteHandlerContext);
        try {
            if (this.writeSheetHolder.getSheetNo() != null) {
                if (WriteTypeEnum.ADD.equals((Object)writeType) && this.writeWorkbookHolder.getTempTemplateInputStream() == null) {
                    currentSheet = this.createSheet();
                } else {
                    currentSheet = this.writeWorkbookHolder.getWorkbook().getSheetAt(this.writeSheetHolder.getSheetNo().intValue());
                    this.writeSheetHolder.setCachedSheet(this.writeWorkbookHolder.getCachedWorkbook().getSheetAt(this.writeSheetHolder.getSheetNo().intValue()));
                }
            } else {
                currentSheet = this.writeWorkbookHolder.getWorkbook().getSheet(this.writeSheetHolder.getSheetName());
                this.writeSheetHolder.setCachedSheet(this.writeWorkbookHolder.getCachedWorkbook().getSheet(this.writeSheetHolder.getSheetName()));
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().contains(NO_SHEETS)) {
                currentSheet = this.createSheet();
            }
            throw e;
        }
        if (currentSheet == null) {
            currentSheet = this.createSheet();
        }
        this.writeSheetHolder.setSheet(currentSheet);
        WriteHandlerUtils.afterSheetCreate(sheetWriteHandlerContext);
        if (WriteTypeEnum.ADD.equals((Object)writeType)) {
            this.initHead(this.writeSheetHolder.excelWriteHeadProperty());
        }
        this.writeWorkbookHolder.getHasBeenInitializedSheetIndexMap().put(this.writeSheetHolder.getSheetNo(), this.writeSheetHolder);
        this.writeWorkbookHolder.getHasBeenInitializedSheetNameMap().put(this.writeSheetHolder.getSheetName(), this.writeSheetHolder);
    }

    private Sheet createSheet() {
        if (log.isDebugEnabled()) {
            log.debug("Can not find sheet:{} ,now create it", (Object)this.writeSheetHolder.getSheetNo());
        }
        if (StringUtils.isEmpty(this.writeSheetHolder.getSheetName())) {
            this.writeSheetHolder.setSheetName(this.writeSheetHolder.getSheetNo().toString());
        }
        Sheet currentSheet = WorkBookUtil.createSheet(this.writeWorkbookHolder.getWorkbook(), this.writeSheetHolder.getSheetName());
        this.writeSheetHolder.setCachedSheet(currentSheet);
        return currentSheet;
    }

    public void initHead(ExcelWriteHeadProperty excelWriteHeadProperty) {
        if (!this.currentWriteHolder.needHead() || !this.currentWriteHolder.excelWriteHeadProperty().hasHead()) {
            return;
        }
        int newRowIndex = this.writeSheetHolder.getNewRowIndexAndStartDoWrite();
        newRowIndex += this.currentWriteHolder.relativeHeadRowIndex();
        if (this.currentWriteHolder.automaticMergeHead()) {
            this.addMergedRegionToCurrentSheet(excelWriteHeadProperty, newRowIndex);
        }
        int relativeRowIndex = 0;
        int i = newRowIndex;
        while (i < excelWriteHeadProperty.getHeadRowNumber() + newRowIndex) {
            RowWriteHandlerContext rowWriteHandlerContext = WriteHandlerUtils.createRowWriteHandlerContext(this, newRowIndex, relativeRowIndex, Boolean.TRUE);
            WriteHandlerUtils.beforeRowCreate(rowWriteHandlerContext);
            Row row = WorkBookUtil.createRow(this.writeSheetHolder.getSheet(), i);
            rowWriteHandlerContext.setRow(row);
            WriteHandlerUtils.afterRowCreate(rowWriteHandlerContext);
            this.addOneRowOfHeadDataToExcel(row, i, excelWriteHeadProperty.getHeadMap(), relativeRowIndex);
            WriteHandlerUtils.afterRowDispose(rowWriteHandlerContext);
            ++i;
            ++relativeRowIndex;
        }
    }

    private void addMergedRegionToCurrentSheet(ExcelWriteHeadProperty excelWriteHeadProperty, int rowIndex) {
        for (CellRange cellRangeModel : excelWriteHeadProperty.headCellRangeList()) {
            this.writeSheetHolder.getSheet().addMergedRegionUnsafe(new CellRangeAddress(cellRangeModel.getFirstRow() + rowIndex, cellRangeModel.getLastRow() + rowIndex, cellRangeModel.getFirstCol(), cellRangeModel.getLastCol()));
        }
    }

    private void addOneRowOfHeadDataToExcel(Row row, Integer rowIndex, Map<Integer, Head> headMap, int relativeRowIndex) {
        for (Map.Entry<Integer, Head> entry : headMap.entrySet()) {
            Head head = entry.getValue();
            int columnIndex = entry.getKey();
            ExcelContentProperty excelContentProperty = ClassUtils.declaredExcelContentProperty(null, this.currentWriteHolder.excelWriteHeadProperty().getHeadClazz(), head.getFieldName(), this.currentWriteHolder);
            CellWriteHandlerContext cellWriteHandlerContext = WriteHandlerUtils.createCellWriteHandlerContext(this, row, rowIndex, head, columnIndex, relativeRowIndex, Boolean.TRUE, excelContentProperty);
            WriteHandlerUtils.beforeCellCreate(cellWriteHandlerContext);
            Cell cell = row.createCell(columnIndex);
            cellWriteHandlerContext.setCell(cell);
            WriteHandlerUtils.afterCellCreate(cellWriteHandlerContext);
            WriteCellData writeCellData = new WriteCellData(head.getHeadNameList().get(relativeRowIndex));
            cell.setCellValue(writeCellData.getStringValue());
            cellWriteHandlerContext.setCellDataList(ListUtils.newArrayList(writeCellData));
            cellWriteHandlerContext.setFirstCellData(writeCellData);
            WriteHandlerUtils.afterCellDispose(cellWriteHandlerContext);
        }
    }

    @Override
    public void currentTable(WriteTable writeTable) {
        if (writeTable == null) {
            return;
        }
        if (writeTable.getTableNo() == null || writeTable.getTableNo() <= 0) {
            writeTable.setTableNo(0);
        }
        if (this.writeSheetHolder.getHasBeenInitializedTable().containsKey(writeTable.getTableNo())) {
            if (log.isDebugEnabled()) {
                log.debug("Table:{} is already existed", (Object)writeTable.getTableNo());
            }
            this.writeTableHolder = this.writeSheetHolder.getHasBeenInitializedTable().get(writeTable.getTableNo());
            this.writeTableHolder.setNewInitialization(Boolean.FALSE);
            this.currentWriteHolder = this.writeTableHolder;
            if (log.isDebugEnabled()) {
                log.debug("CurrentConfiguration is writeTableHolder");
            }
            return;
        }
        this.initCurrentTableHolder(writeTable);
        WorkbookWriteHandlerContext workbookWriteHandlerContext = WriteHandlerUtils.createWorkbookWriteHandlerContext(this);
        WriteHandlerUtils.beforeWorkbookCreate(workbookWriteHandlerContext, true);
        WriteHandlerUtils.afterWorkbookCreate(workbookWriteHandlerContext, true);
        SheetWriteHandlerContext sheetWriteHandlerContext = WriteHandlerUtils.createSheetWriteHandlerContext(this);
        WriteHandlerUtils.beforeSheetCreate(sheetWriteHandlerContext, true);
        WriteHandlerUtils.afterSheetCreate(sheetWriteHandlerContext, true);
        this.initHead(this.writeTableHolder.excelWriteHeadProperty());
    }

    private void initCurrentTableHolder(WriteTable writeTable) {
        this.writeTableHolder = new WriteTableHolder(writeTable, this.writeSheetHolder);
        this.writeSheetHolder.getHasBeenInitializedTable().put(writeTable.getTableNo(), this.writeTableHolder);
        this.currentWriteHolder = this.writeTableHolder;
        if (log.isDebugEnabled()) {
            log.debug("CurrentConfiguration is writeTableHolder");
        }
    }

    @Override
    public WriteWorkbookHolder writeWorkbookHolder() {
        return this.writeWorkbookHolder;
    }

    @Override
    public WriteSheetHolder writeSheetHolder() {
        return this.writeSheetHolder;
    }

    @Override
    public WriteTableHolder writeTableHolder() {
        return this.writeTableHolder;
    }

    @Override
    public WriteHolder currentWriteHolder() {
        return this.currentWriteHolder;
    }

    @Override
    public void finish(boolean onException) {
        boolean writeExcel;
        if (this.finished) {
            return;
        }
        this.finished = true;
        WriteHandlerUtils.afterWorkbookDispose(this.writeWorkbookHolder.getWorkbookWriteHandlerContext());
        if (this.writeWorkbookHolder == null) {
            return;
        }
        Throwable throwable = null;
        boolean isOutputStreamEncrypt = false;
        boolean bl = writeExcel = !onException;
        if (this.writeWorkbookHolder.getWriteExcelOnException().booleanValue()) {
            writeExcel = Boolean.TRUE;
        }
        if (writeExcel) {
            try {
                isOutputStreamEncrypt = this.doOutputStreamEncrypt07();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (!isOutputStreamEncrypt) {
            try {
                if (writeExcel) {
                    this.writeWorkbookHolder.getWorkbook().write(this.writeWorkbookHolder.getOutputStream());
                }
                this.writeWorkbookHolder.getWorkbook().close();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            Workbook workbook = this.writeWorkbookHolder.getWorkbook();
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (this.writeWorkbookHolder.getAutoCloseStream().booleanValue() && this.writeWorkbookHolder.getOutputStream() != null) {
                this.writeWorkbookHolder.getOutputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (writeExcel && !isOutputStreamEncrypt) {
            try {
                this.doFileEncrypt07();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            if (this.writeWorkbookHolder.getTempTemplateInputStream() != null) {
                this.writeWorkbookHolder.getTempTemplateInputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        this.clearEncrypt03();
        this.removeThreadLocalCache();
        if (throwable != null) {
            throw new ExcelGenerateException("Can not close IO.", throwable);
        }
        if (log.isDebugEnabled()) {
            log.debug("Finished write.");
        }
    }

    private void removeThreadLocalCache() {
        NumberDataFormatterUtils.removeThreadLocalCache();
        DateUtils.removeThreadLocalCache();
        ClassUtils.removeThreadLocalCache();
    }

    @Override
    public Sheet getCurrentSheet() {
        return this.writeSheetHolder.getSheet();
    }

    @Override
    public boolean needHead() {
        return this.writeSheetHolder.needHead();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.writeWorkbookHolder.getOutputStream();
    }

    @Override
    public Workbook getWorkbook() {
        return this.writeWorkbookHolder.getWorkbook();
    }

    private void clearEncrypt03() {
        if (StringUtils.isEmpty(this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLS.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return;
        }
        Biff8EncryptionKey.setCurrentUserPassword(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOutputStreamEncrypt07() throws Exception {
        if (StringUtils.isEmpty(this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLSX.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return false;
        }
        if (this.writeWorkbookHolder.getFile() != null) {
            return false;
        }
        File tempXlsx = FileUtils.createTmpFile(UUID.randomUUID() + ".xlsx");
        FileOutputStream tempFileOutputStream = new FileOutputStream(tempXlsx);
        try {
            this.writeWorkbookHolder.getWorkbook().write((OutputStream)tempFileOutputStream);
        }
        finally {
            try {
                this.writeWorkbookHolder.getWorkbook().close();
                tempFileOutputStream.close();
            }
            catch (Exception e) {
                if (!tempXlsx.delete()) {
                    throw new ExcelGenerateException("Can not delete temp File!");
                }
                throw e;
            }
        }
        try (POIFSFileSystem fileSystem = this.openFileSystemAndEncrypt(tempXlsx);){
            fileSystem.writeFilesystem(this.writeWorkbookHolder.getOutputStream());
        }
        finally {
            if (!tempXlsx.delete()) {
                throw new ExcelGenerateException("Can not delete temp File!");
            }
        }
        return true;
    }

    private void doFileEncrypt07() throws Exception {
        if (StringUtils.isEmpty(this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLSX.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return;
        }
        if (this.writeWorkbookHolder.getFile() == null) {
            return;
        }
        try (POIFSFileSystem fileSystem = this.openFileSystemAndEncrypt(this.writeWorkbookHolder.getFile());
             FileOutputStream fileOutputStream = new FileOutputStream(this.writeWorkbookHolder.getFile());){
            fileSystem.writeFilesystem((OutputStream)fileOutputStream);
        }
    }

    private POIFSFileSystem openFileSystemAndEncrypt(File file) throws Exception {
        POIFSFileSystem fileSystem = new POIFSFileSystem();
        Encryptor encryptor = new EncryptionInfo(EncryptionMode.standard).getEncryptor();
        encryptor.confirmPassword(this.writeWorkbookHolder.getPassword());
        try (OPCPackage opcPackage = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ_WRITE);
             OutputStream outputStream = encryptor.getDataStream(fileSystem);){
            opcPackage.save(outputStream);
        }
        return fileSystem;
    }
}

