/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.context;

import cn.idev.excel.context.AnalysisContext;
import cn.idev.excel.exception.ExcelAnalysisException;
import cn.idev.excel.read.metadata.ReadSheet;
import cn.idev.excel.read.metadata.ReadWorkbook;
import cn.idev.excel.read.metadata.holder.ReadHolder;
import cn.idev.excel.read.metadata.holder.ReadRowHolder;
import cn.idev.excel.read.metadata.holder.ReadSheetHolder;
import cn.idev.excel.read.metadata.holder.ReadWorkbookHolder;
import cn.idev.excel.read.metadata.holder.csv.CsvReadSheetHolder;
import cn.idev.excel.read.metadata.holder.csv.CsvReadWorkbookHolder;
import cn.idev.excel.read.metadata.holder.xls.XlsReadSheetHolder;
import cn.idev.excel.read.metadata.holder.xls.XlsReadWorkbookHolder;
import cn.idev.excel.read.metadata.holder.xlsx.XlsxReadSheetHolder;
import cn.idev.excel.read.metadata.holder.xlsx.XlsxReadWorkbookHolder;
import cn.idev.excel.read.processor.AnalysisEventProcessor;
import cn.idev.excel.read.processor.DefaultAnalysisEventProcessor;
import cn.idev.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisContextImpl
implements AnalysisContext {
    private static final Logger log = LoggerFactory.getLogger(AnalysisContextImpl.class);
    private ReadWorkbookHolder readWorkbookHolder;
    private ReadSheetHolder readSheetHolder;
    private ReadRowHolder readRowHolder;
    private ReadHolder currentReadHolder;
    private final AnalysisEventProcessor analysisEventProcessor;

    public AnalysisContextImpl(ReadWorkbook readWorkbook, ExcelTypeEnum actualExcelType) {
        if (readWorkbook == null) {
            throw new IllegalArgumentException("Workbook argument cannot be null");
        }
        switch (actualExcelType) {
            case XLS: {
                this.readWorkbookHolder = new XlsReadWorkbookHolder(readWorkbook);
                break;
            }
            case XLSX: {
                this.readWorkbookHolder = new XlsxReadWorkbookHolder(readWorkbook);
                break;
            }
            case CSV: {
                this.readWorkbookHolder = new CsvReadWorkbookHolder(readWorkbook);
                break;
            }
        }
        this.currentReadHolder = this.readWorkbookHolder;
        this.analysisEventProcessor = new DefaultAnalysisEventProcessor();
        if (log.isDebugEnabled()) {
            log.debug("Initialization 'AnalysisContextImpl' complete");
        }
    }

    @Override
    public void currentSheet(ReadSheet readSheet) {
        switch (this.readWorkbookHolder.getExcelType()) {
            case XLS: {
                this.readSheetHolder = new XlsReadSheetHolder(readSheet, this.readWorkbookHolder);
                break;
            }
            case XLSX: {
                this.readSheetHolder = new XlsxReadSheetHolder(readSheet, this.readWorkbookHolder);
                break;
            }
            case CSV: {
                this.readSheetHolder = new CsvReadSheetHolder(readSheet, this.readWorkbookHolder);
                break;
            }
        }
        this.currentReadHolder = this.readSheetHolder;
        if (this.readWorkbookHolder.getHasReadSheet().contains(this.readSheetHolder.getSheetNo())) {
            throw new ExcelAnalysisException("Cannot read sheet repeatedly.");
        }
        this.readWorkbookHolder.getHasReadSheet().add(this.readSheetHolder.getSheetNo());
        if (log.isDebugEnabled()) {
            log.debug("Began to read\uff1a{}", (Object)this.readSheetHolder);
        }
    }

    @Override
    public ReadWorkbookHolder readWorkbookHolder() {
        return this.readWorkbookHolder;
    }

    @Override
    public ReadSheetHolder readSheetHolder() {
        return this.readSheetHolder;
    }

    @Override
    public ReadRowHolder readRowHolder() {
        return this.readRowHolder;
    }

    @Override
    public void readRowHolder(ReadRowHolder readRowHolder) {
        this.readRowHolder = readRowHolder;
    }

    @Override
    public ReadHolder currentReadHolder() {
        return this.currentReadHolder;
    }

    @Override
    public Object getCustom() {
        return this.readWorkbookHolder.getCustomObject();
    }

    @Override
    public AnalysisEventProcessor analysisEventProcessor() {
        return this.analysisEventProcessor;
    }

    @Override
    public List<ReadSheet> readSheetList() {
        return null;
    }

    @Override
    public void readSheetList(List<ReadSheet> readSheetList) {
    }

    @Override
    public ExcelTypeEnum getExcelType() {
        return this.readWorkbookHolder.getExcelType();
    }

    @Override
    public InputStream getInputStream() {
        return this.readWorkbookHolder.getInputStream();
    }

    @Override
    public Integer getCurrentRowNum() {
        return this.readRowHolder.getRowIndex();
    }

    @Override
    public Integer getTotalCount() {
        return this.readSheetHolder.getTotal();
    }

    @Override
    public Object getCurrentRowAnalysisResult() {
        return this.readRowHolder.getCurrentRowAnalysisResult();
    }

    @Override
    public void interrupt() {
        throw new ExcelAnalysisException("interrupt error");
    }
}

