/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.getter.OptNullBasicTypeFromStringGetter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.StaticLog;
import java.io.Serializable;
import java.lang.reflect.Type;

public abstract class AbsSetting
extends OptNullBasicTypeFromStringGetter<String>
implements Serializable {
    private static final long serialVersionUID = 6200156302595905863L;
    private static final Log log = StaticLog.get();
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_GROUP = "";

    public String getStr(String key, String defaultValue) {
        return this.getByGroup(key, DEFAULT_GROUP);
    }

    public String getStr(String key, String group, String defaultValue) {
        String value = this.getByGroup(key, group);
        if (StrUtil.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public abstract String getByGroup(String var1, String var2);

    public String getWithLog(String key) {
        String value = this.getStr(key);
        if (value == null) {
            log.debug("No key define for [{}]!", new Object[]{key});
        }
        return value;
    }

    public String getByGroupWithLog(String key, String group) {
        String value = this.getByGroup(key, group);
        if (value == null) {
            log.debug("No key define for [{}] of group [{}] !", new Object[]{key, group});
        }
        return value;
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, DEFAULT_DELIMITER);
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getByGroup(key, group);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return StrUtil.split((CharSequence)value, (CharSequence)delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Convert.toInt((Object)this.getByGroup(key, group), (Integer)defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Convert.toBool((Object)this.getByGroup(key, group), (Boolean)defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Convert.toLong((Object)this.getByGroup(key, group), (Long)defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.getByGroup(key, group);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Convert.toDouble((Object)this.getByGroup(key, group), (Double)defaultValue);
    }

    public Object toBean(final String group, Object bean) {
        return BeanUtil.fillBean((Object)bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                String value = AbsSetting.this.getByGroup(key, group);
                if (null != value) {
                    log.debug("Parse setting to object field [{}={}]", new Object[]{key, value});
                }
                return value;
            }

            public boolean containsKey(String key) {
                return null != AbsSetting.this.getByGroup(key, group);
            }
        }, (CopyOptions)CopyOptions.create());
    }

    public Object toBean(Object bean) {
        return this.toBean(null, bean);
    }
}

