/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.slf4j;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public Slf4jLog(Logger logger) {
        this.logger = logger;
    }

    public Slf4jLog(Class<?> clazz) {
        this(Slf4jLog.getSlf4jLogger(clazz));
    }

    public Slf4jLog(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isTraceEnabled() && !this.locationAwareLog(fqcn, 0, t, format, arguments)) {
            this.logger.trace(StrUtil.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isDebugEnabled() && !this.locationAwareLog(fqcn, 10, t, format, arguments)) {
            this.logger.debug(StrUtil.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isInfoEnabled() && !this.locationAwareLog(fqcn, 20, t, format, arguments)) {
            this.logger.info(StrUtil.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isWarnEnabled() && !this.locationAwareLog(fqcn, 30, t, format, arguments)) {
            this.logger.warn(StrUtil.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isErrorEnabled() && !this.locationAwareLog(fqcn, 40, t, format, arguments)) {
            this.logger.error(StrUtil.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        int level_int;
        switch (level) {
            case TRACE: {
                level_int = 0;
                break;
            }
            case DEBUG: {
                level_int = 10;
                break;
            }
            case INFO: {
                level_int = 20;
                break;
            }
            case WARN: {
                level_int = 30;
                break;
            }
            case ERROR: {
                level_int = 40;
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
            }
        }
        this.locationAwareLog(fqcn, level_int, t, format, arguments);
    }

    private boolean locationAwareLog(String fqcn, int level_int, Throwable t, String msgTemplate, Object[] arguments) {
        if (this.logger instanceof LocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, fqcn, level_int, StrUtil.format((CharSequence)msgTemplate, (Object[])arguments), null, t);
            return true;
        }
        return false;
    }

    private static Logger getSlf4jLogger(Class<?> clazz) {
        return null == clazz ? LoggerFactory.getLogger((String)"") : LoggerFactory.getLogger(clazz);
    }
}

