/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.CacheObjIterator;
import cn.hutool.cache.impl.CacheValuesIterator;
import cn.hutool.core.collection.CopiedIter;
import cn.hutool.core.lang.func.Func0;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 1L;
    protected Map<K, CacheObj<K, V>> cacheMap;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected int hitCount;
    protected int missCount;

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        this.writeLock.lock();
        try {
            this.putWithoutLock(key, object, timeout);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void putWithoutLock(K key, V object, long timeout) {
        CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put(key, co);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        this.readLock.lock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                boolean bl = false;
                return bl;
            }
            if (!co.isExpired()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.remove(key, true);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHitCount() {
        this.readLock.lock();
        try {
            int n = this.hitCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMissCount() {
        this.readLock.lock();
        try {
            int n = this.missCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(K key) {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, Func0<V> supplier) {
        V v;
        block7: {
            v = this.get(key);
            if (null == v && null != supplier) {
                this.writeLock.lock();
                try {
                    CacheObj<K, V> co = this.cacheMap.get(key);
                    if (null == co || co.isExpired() || null == co.getValue()) {
                        try {
                            v = supplier.call();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        this.putWithoutLock(key, v, this.timeout);
                        break block7;
                    }
                    v = co.get(true);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        this.readLock.lock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                ++this.missCount;
                V v = null;
                return v;
            }
            if (!co.isExpired()) {
                ++this.hitCount;
                V v = co.get(isUpdateLastAccess);
                return v;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.remove(key, true);
        return null;
    }

    @Override
    public Iterator<V> iterator() {
        CacheObjIterator copiedIterator = (CacheObjIterator)this.cacheObjIterator();
        return new CacheValuesIterator(copiedIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        CopiedIter<CacheObj<K, V>> copiedIterator;
        this.readLock.lock();
        try {
            copiedIterator = CopiedIter.copyOf(this.cacheMap.values().iterator());
        }
        finally {
            this.readLock.unlock();
        }
        return new CacheObjIterator<K, V>(copiedIterator);
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        this.writeLock.lock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPruneExpiredActive() {
        this.readLock.lock();
        try {
            boolean bl = this.timeout != 0L || this.existCustomTimeout;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        this.readLock.lock();
        try {
            boolean bl = this.capacity > 0 && this.cacheMap.size() >= this.capacity;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void remove(K key) {
        this.remove(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.cacheMap.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.cacheMap.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            String string = this.cacheMap.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void onRemove(K key, V cachedObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(K key, boolean withMissCount) {
        CacheObj<K, V> co;
        this.writeLock.lock();
        try {
            co = this.removeWithoutLock(key, withMissCount);
        }
        finally {
            this.writeLock.unlock();
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    private CacheObj<K, V> removeWithoutLock(K key, boolean withMissCount) {
        CacheObj<K, V> co = this.cacheMap.remove(key);
        if (withMissCount) {
            ++this.missCount;
        }
        return co;
    }
}

