/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.util;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public final class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    private BeanUtil() {
    }

    public static void registerIfAbsent(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Map<String, Object> properties, Object ... constructorArgs) {
        if (BeanUtil.ifPresent(registry, beanName, clazz) || registry.containsBeanDefinition(beanName)) {
            log.warn("DynamicTp registrar, bean definition already exists, overrides with remote config, beanName: {}", (Object)beanName);
            registry.removeBeanDefinition(beanName);
        }
        BeanUtil.doRegister(registry, beanName, clazz, properties, constructorArgs);
    }

    public static boolean ifPresent(BeanDefinitionRegistry registry, String beanName, Class<?> clazz) {
        Object[] beanNames = BeanUtil.getBeanNames((ListableBeanFactory)registry, clazz);
        return ArrayUtils.contains((Object[])beanNames, (Object)beanName);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> clazz) {
        return beanFactory.getBeanNamesForType(clazz, true, false);
    }

    public static void doRegister(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Map<String, Object> properties, Object ... constructorArgs) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Object constructorArg : constructorArgs) {
            builder.addConstructorArgValue(constructorArg);
        }
        if (MapUtils.isNotEmpty(properties)) {
            properties.forEach((arg_0, arg_1) -> ((BeanDefinitionBuilder)builder).addPropertyValue(arg_0, arg_1));
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }
}

