/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.properties;

import com.dtp.common.em.CollectorTypeEnum;
import com.dtp.common.entity.NotifyPlatform;
import com.dtp.common.properties.SimpleTpProperties;
import com.dtp.common.properties.ThreadPoolProperties;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.dynamic.tp")
public class DtpProperties {
    private static final Logger log = LoggerFactory.getLogger(DtpProperties.class);
    private boolean enabled = true;
    private boolean enabledBanner = true;
    private Nacos nacos;
    private Apollo apollo;
    private Zookeeper zookeeper;
    private Etcd etcd;
    private String configType = "yml";
    private boolean enabledCollect = false;
    private List<String> collectorTypes = Lists.newArrayList((Object[])new String[]{CollectorTypeEnum.MICROMETER.name()});
    private String logPath;
    private int monitorInterval = 5;
    private List<ThreadPoolProperties> executors;
    private SimpleTpProperties tomcatTp;
    private SimpleTpProperties jettyTp;
    private SimpleTpProperties undertowTp;
    private List<SimpleTpProperties> dubboTp;
    private List<SimpleTpProperties> hystrixTp;
    private List<SimpleTpProperties> rocketMqTp;
    private List<SimpleTpProperties> grpcTp;
    private List<SimpleTpProperties> motanTp;
    private List<SimpleTpProperties> okhttp3Tp;
    private List<SimpleTpProperties> brpcTp;
    private List<SimpleTpProperties> tarsTp;
    private List<SimpleTpProperties> sofaTp;
    private List<NotifyPlatform> platforms;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledBanner() {
        return this.enabledBanner;
    }

    public Nacos getNacos() {
        return this.nacos;
    }

    public Apollo getApollo() {
        return this.apollo;
    }

    public Zookeeper getZookeeper() {
        return this.zookeeper;
    }

    public Etcd getEtcd() {
        return this.etcd;
    }

    public String getConfigType() {
        return this.configType;
    }

    public boolean isEnabledCollect() {
        return this.enabledCollect;
    }

    public List<String> getCollectorTypes() {
        return this.collectorTypes;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public List<ThreadPoolProperties> getExecutors() {
        return this.executors;
    }

    public SimpleTpProperties getTomcatTp() {
        return this.tomcatTp;
    }

    public SimpleTpProperties getJettyTp() {
        return this.jettyTp;
    }

    public SimpleTpProperties getUndertowTp() {
        return this.undertowTp;
    }

    public List<SimpleTpProperties> getDubboTp() {
        return this.dubboTp;
    }

    public List<SimpleTpProperties> getHystrixTp() {
        return this.hystrixTp;
    }

    public List<SimpleTpProperties> getRocketMqTp() {
        return this.rocketMqTp;
    }

    public List<SimpleTpProperties> getGrpcTp() {
        return this.grpcTp;
    }

    public List<SimpleTpProperties> getMotanTp() {
        return this.motanTp;
    }

    public List<SimpleTpProperties> getOkhttp3Tp() {
        return this.okhttp3Tp;
    }

    public List<SimpleTpProperties> getBrpcTp() {
        return this.brpcTp;
    }

    public List<SimpleTpProperties> getTarsTp() {
        return this.tarsTp;
    }

    public List<SimpleTpProperties> getSofaTp() {
        return this.sofaTp;
    }

    public List<NotifyPlatform> getPlatforms() {
        return this.platforms;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledBanner(boolean enabledBanner) {
        this.enabledBanner = enabledBanner;
    }

    public void setNacos(Nacos nacos) {
        this.nacos = nacos;
    }

    public void setApollo(Apollo apollo) {
        this.apollo = apollo;
    }

    public void setZookeeper(Zookeeper zookeeper) {
        this.zookeeper = zookeeper;
    }

    public void setEtcd(Etcd etcd) {
        this.etcd = etcd;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public void setEnabledCollect(boolean enabledCollect) {
        this.enabledCollect = enabledCollect;
    }

    public void setCollectorTypes(List<String> collectorTypes) {
        this.collectorTypes = collectorTypes;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void setExecutors(List<ThreadPoolProperties> executors) {
        this.executors = executors;
    }

    public void setTomcatTp(SimpleTpProperties tomcatTp) {
        this.tomcatTp = tomcatTp;
    }

    public void setJettyTp(SimpleTpProperties jettyTp) {
        this.jettyTp = jettyTp;
    }

    public void setUndertowTp(SimpleTpProperties undertowTp) {
        this.undertowTp = undertowTp;
    }

    public void setDubboTp(List<SimpleTpProperties> dubboTp) {
        this.dubboTp = dubboTp;
    }

    public void setHystrixTp(List<SimpleTpProperties> hystrixTp) {
        this.hystrixTp = hystrixTp;
    }

    public void setRocketMqTp(List<SimpleTpProperties> rocketMqTp) {
        this.rocketMqTp = rocketMqTp;
    }

    public void setGrpcTp(List<SimpleTpProperties> grpcTp) {
        this.grpcTp = grpcTp;
    }

    public void setMotanTp(List<SimpleTpProperties> motanTp) {
        this.motanTp = motanTp;
    }

    public void setOkhttp3Tp(List<SimpleTpProperties> okhttp3Tp) {
        this.okhttp3Tp = okhttp3Tp;
    }

    public void setBrpcTp(List<SimpleTpProperties> brpcTp) {
        this.brpcTp = brpcTp;
    }

    public void setTarsTp(List<SimpleTpProperties> tarsTp) {
        this.tarsTp = tarsTp;
    }

    public void setSofaTp(List<SimpleTpProperties> sofaTp) {
        this.sofaTp = sofaTp;
    }

    public void setPlatforms(List<NotifyPlatform> platforms) {
        this.platforms = platforms;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DtpProperties)) {
            return false;
        }
        DtpProperties other = (DtpProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isEnabledBanner() != other.isEnabledBanner()) {
            return false;
        }
        if (this.isEnabledCollect() != other.isEnabledCollect()) {
            return false;
        }
        if (this.getMonitorInterval() != other.getMonitorInterval()) {
            return false;
        }
        Nacos this$nacos = this.getNacos();
        Nacos other$nacos = other.getNacos();
        if (this$nacos == null ? other$nacos != null : !((Object)this$nacos).equals(other$nacos)) {
            return false;
        }
        Apollo this$apollo = this.getApollo();
        Apollo other$apollo = other.getApollo();
        if (this$apollo == null ? other$apollo != null : !((Object)this$apollo).equals(other$apollo)) {
            return false;
        }
        Zookeeper this$zookeeper = this.getZookeeper();
        Zookeeper other$zookeeper = other.getZookeeper();
        if (this$zookeeper == null ? other$zookeeper != null : !((Object)this$zookeeper).equals(other$zookeeper)) {
            return false;
        }
        Etcd this$etcd = this.getEtcd();
        Etcd other$etcd = other.getEtcd();
        if (this$etcd == null ? other$etcd != null : !((Object)this$etcd).equals(other$etcd)) {
            return false;
        }
        String this$configType = this.getConfigType();
        String other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        List<String> this$collectorTypes = this.getCollectorTypes();
        List<String> other$collectorTypes = other.getCollectorTypes();
        if (this$collectorTypes == null ? other$collectorTypes != null : !((Object)this$collectorTypes).equals(other$collectorTypes)) {
            return false;
        }
        String this$logPath = this.getLogPath();
        String other$logPath = other.getLogPath();
        if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
            return false;
        }
        List<ThreadPoolProperties> this$executors = this.getExecutors();
        List<ThreadPoolProperties> other$executors = other.getExecutors();
        if (this$executors == null ? other$executors != null : !((Object)this$executors).equals(other$executors)) {
            return false;
        }
        SimpleTpProperties this$tomcatTp = this.getTomcatTp();
        SimpleTpProperties other$tomcatTp = other.getTomcatTp();
        if (this$tomcatTp == null ? other$tomcatTp != null : !((Object)this$tomcatTp).equals(other$tomcatTp)) {
            return false;
        }
        SimpleTpProperties this$jettyTp = this.getJettyTp();
        SimpleTpProperties other$jettyTp = other.getJettyTp();
        if (this$jettyTp == null ? other$jettyTp != null : !((Object)this$jettyTp).equals(other$jettyTp)) {
            return false;
        }
        SimpleTpProperties this$undertowTp = this.getUndertowTp();
        SimpleTpProperties other$undertowTp = other.getUndertowTp();
        if (this$undertowTp == null ? other$undertowTp != null : !((Object)this$undertowTp).equals(other$undertowTp)) {
            return false;
        }
        List<SimpleTpProperties> this$dubboTp = this.getDubboTp();
        List<SimpleTpProperties> other$dubboTp = other.getDubboTp();
        if (this$dubboTp == null ? other$dubboTp != null : !((Object)this$dubboTp).equals(other$dubboTp)) {
            return false;
        }
        List<SimpleTpProperties> this$hystrixTp = this.getHystrixTp();
        List<SimpleTpProperties> other$hystrixTp = other.getHystrixTp();
        if (this$hystrixTp == null ? other$hystrixTp != null : !((Object)this$hystrixTp).equals(other$hystrixTp)) {
            return false;
        }
        List<SimpleTpProperties> this$rocketMqTp = this.getRocketMqTp();
        List<SimpleTpProperties> other$rocketMqTp = other.getRocketMqTp();
        if (this$rocketMqTp == null ? other$rocketMqTp != null : !((Object)this$rocketMqTp).equals(other$rocketMqTp)) {
            return false;
        }
        List<SimpleTpProperties> this$grpcTp = this.getGrpcTp();
        List<SimpleTpProperties> other$grpcTp = other.getGrpcTp();
        if (this$grpcTp == null ? other$grpcTp != null : !((Object)this$grpcTp).equals(other$grpcTp)) {
            return false;
        }
        List<SimpleTpProperties> this$motanTp = this.getMotanTp();
        List<SimpleTpProperties> other$motanTp = other.getMotanTp();
        if (this$motanTp == null ? other$motanTp != null : !((Object)this$motanTp).equals(other$motanTp)) {
            return false;
        }
        List<SimpleTpProperties> this$okhttp3Tp = this.getOkhttp3Tp();
        List<SimpleTpProperties> other$okhttp3Tp = other.getOkhttp3Tp();
        if (this$okhttp3Tp == null ? other$okhttp3Tp != null : !((Object)this$okhttp3Tp).equals(other$okhttp3Tp)) {
            return false;
        }
        List<SimpleTpProperties> this$brpcTp = this.getBrpcTp();
        List<SimpleTpProperties> other$brpcTp = other.getBrpcTp();
        if (this$brpcTp == null ? other$brpcTp != null : !((Object)this$brpcTp).equals(other$brpcTp)) {
            return false;
        }
        List<SimpleTpProperties> this$tarsTp = this.getTarsTp();
        List<SimpleTpProperties> other$tarsTp = other.getTarsTp();
        if (this$tarsTp == null ? other$tarsTp != null : !((Object)this$tarsTp).equals(other$tarsTp)) {
            return false;
        }
        List<SimpleTpProperties> this$sofaTp = this.getSofaTp();
        List<SimpleTpProperties> other$sofaTp = other.getSofaTp();
        if (this$sofaTp == null ? other$sofaTp != null : !((Object)this$sofaTp).equals(other$sofaTp)) {
            return false;
        }
        List<NotifyPlatform> this$platforms = this.getPlatforms();
        List<NotifyPlatform> other$platforms = other.getPlatforms();
        return !(this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DtpProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnabledBanner() ? 79 : 97);
        result = result * 59 + (this.isEnabledCollect() ? 79 : 97);
        result = result * 59 + this.getMonitorInterval();
        Nacos $nacos = this.getNacos();
        result = result * 59 + ($nacos == null ? 43 : ((Object)$nacos).hashCode());
        Apollo $apollo = this.getApollo();
        result = result * 59 + ($apollo == null ? 43 : ((Object)$apollo).hashCode());
        Zookeeper $zookeeper = this.getZookeeper();
        result = result * 59 + ($zookeeper == null ? 43 : ((Object)$zookeeper).hashCode());
        Etcd $etcd = this.getEtcd();
        result = result * 59 + ($etcd == null ? 43 : ((Object)$etcd).hashCode());
        String $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        List<String> $collectorTypes = this.getCollectorTypes();
        result = result * 59 + ($collectorTypes == null ? 43 : ((Object)$collectorTypes).hashCode());
        String $logPath = this.getLogPath();
        result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
        List<ThreadPoolProperties> $executors = this.getExecutors();
        result = result * 59 + ($executors == null ? 43 : ((Object)$executors).hashCode());
        SimpleTpProperties $tomcatTp = this.getTomcatTp();
        result = result * 59 + ($tomcatTp == null ? 43 : ((Object)$tomcatTp).hashCode());
        SimpleTpProperties $jettyTp = this.getJettyTp();
        result = result * 59 + ($jettyTp == null ? 43 : ((Object)$jettyTp).hashCode());
        SimpleTpProperties $undertowTp = this.getUndertowTp();
        result = result * 59 + ($undertowTp == null ? 43 : ((Object)$undertowTp).hashCode());
        List<SimpleTpProperties> $dubboTp = this.getDubboTp();
        result = result * 59 + ($dubboTp == null ? 43 : ((Object)$dubboTp).hashCode());
        List<SimpleTpProperties> $hystrixTp = this.getHystrixTp();
        result = result * 59 + ($hystrixTp == null ? 43 : ((Object)$hystrixTp).hashCode());
        List<SimpleTpProperties> $rocketMqTp = this.getRocketMqTp();
        result = result * 59 + ($rocketMqTp == null ? 43 : ((Object)$rocketMqTp).hashCode());
        List<SimpleTpProperties> $grpcTp = this.getGrpcTp();
        result = result * 59 + ($grpcTp == null ? 43 : ((Object)$grpcTp).hashCode());
        List<SimpleTpProperties> $motanTp = this.getMotanTp();
        result = result * 59 + ($motanTp == null ? 43 : ((Object)$motanTp).hashCode());
        List<SimpleTpProperties> $okhttp3Tp = this.getOkhttp3Tp();
        result = result * 59 + ($okhttp3Tp == null ? 43 : ((Object)$okhttp3Tp).hashCode());
        List<SimpleTpProperties> $brpcTp = this.getBrpcTp();
        result = result * 59 + ($brpcTp == null ? 43 : ((Object)$brpcTp).hashCode());
        List<SimpleTpProperties> $tarsTp = this.getTarsTp();
        result = result * 59 + ($tarsTp == null ? 43 : ((Object)$tarsTp).hashCode());
        List<SimpleTpProperties> $sofaTp = this.getSofaTp();
        result = result * 59 + ($sofaTp == null ? 43 : ((Object)$sofaTp).hashCode());
        List<NotifyPlatform> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        return result;
    }

    public String toString() {
        return "DtpProperties(enabled=" + this.isEnabled() + ", enabledBanner=" + this.isEnabledBanner() + ", nacos=" + this.getNacos() + ", apollo=" + this.getApollo() + ", zookeeper=" + this.getZookeeper() + ", etcd=" + this.getEtcd() + ", configType=" + this.getConfigType() + ", enabledCollect=" + this.isEnabledCollect() + ", collectorTypes=" + this.getCollectorTypes() + ", logPath=" + this.getLogPath() + ", monitorInterval=" + this.getMonitorInterval() + ", executors=" + this.getExecutors() + ", tomcatTp=" + this.getTomcatTp() + ", jettyTp=" + this.getJettyTp() + ", undertowTp=" + this.getUndertowTp() + ", dubboTp=" + this.getDubboTp() + ", hystrixTp=" + this.getHystrixTp() + ", rocketMqTp=" + this.getRocketMqTp() + ", grpcTp=" + this.getGrpcTp() + ", motanTp=" + this.getMotanTp() + ", okhttp3Tp=" + this.getOkhttp3Tp() + ", brpcTp=" + this.getBrpcTp() + ", tarsTp=" + this.getTarsTp() + ", sofaTp=" + this.getSofaTp() + ", platforms=" + this.getPlatforms() + ")";
    }

    public static class Etcd {
        private String endpoints;
        private String user;
        private String password;
        private String charset = "UTF-8";
        private Boolean authEnable = false;
        private String authority = "ssl";
        private String key;

        public String getEndpoints() {
            return this.endpoints;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getCharset() {
            return this.charset;
        }

        public Boolean getAuthEnable() {
            return this.authEnable;
        }

        public String getAuthority() {
            return this.authority;
        }

        public String getKey() {
            return this.key;
        }

        public void setEndpoints(String endpoints) {
            this.endpoints = endpoints;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setAuthEnable(Boolean authEnable) {
            this.authEnable = authEnable;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Etcd)) {
                return false;
            }
            Etcd other = (Etcd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$authEnable = this.getAuthEnable();
            Boolean other$authEnable = other.getAuthEnable();
            if (this$authEnable == null ? other$authEnable != null : !((Object)this$authEnable).equals(other$authEnable)) {
                return false;
            }
            String this$endpoints = this.getEndpoints();
            String other$endpoints = other.getEndpoints();
            if (this$endpoints == null ? other$endpoints != null : !this$endpoints.equals(other$endpoints)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
                return false;
            }
            String this$authority = this.getAuthority();
            String other$authority = other.getAuthority();
            if (this$authority == null ? other$authority != null : !this$authority.equals(other$authority)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Etcd;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $authEnable = this.getAuthEnable();
            result = result * 59 + ($authEnable == null ? 43 : ((Object)$authEnable).hashCode());
            String $endpoints = this.getEndpoints();
            result = result * 59 + ($endpoints == null ? 43 : $endpoints.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            String $authority = this.getAuthority();
            result = result * 59 + ($authority == null ? 43 : $authority.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        public String toString() {
            return "DtpProperties.Etcd(endpoints=" + this.getEndpoints() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", charset=" + this.getCharset() + ", authEnable=" + this.getAuthEnable() + ", authority=" + this.getAuthority() + ", key=" + this.getKey() + ")";
        }
    }

    public static class Zookeeper {
        private String zkConnectStr;
        private String configVersion;
        private String rootNode;
        private String node;
        private String configKey;

        public String getZkConnectStr() {
            return this.zkConnectStr;
        }

        public String getConfigVersion() {
            return this.configVersion;
        }

        public String getRootNode() {
            return this.rootNode;
        }

        public String getNode() {
            return this.node;
        }

        public String getConfigKey() {
            return this.configKey;
        }

        public void setZkConnectStr(String zkConnectStr) {
            this.zkConnectStr = zkConnectStr;
        }

        public void setConfigVersion(String configVersion) {
            this.configVersion = configVersion;
        }

        public void setRootNode(String rootNode) {
            this.rootNode = rootNode;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public void setConfigKey(String configKey) {
            this.configKey = configKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Zookeeper)) {
                return false;
            }
            Zookeeper other = (Zookeeper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$zkConnectStr = this.getZkConnectStr();
            String other$zkConnectStr = other.getZkConnectStr();
            if (this$zkConnectStr == null ? other$zkConnectStr != null : !this$zkConnectStr.equals(other$zkConnectStr)) {
                return false;
            }
            String this$configVersion = this.getConfigVersion();
            String other$configVersion = other.getConfigVersion();
            if (this$configVersion == null ? other$configVersion != null : !this$configVersion.equals(other$configVersion)) {
                return false;
            }
            String this$rootNode = this.getRootNode();
            String other$rootNode = other.getRootNode();
            if (this$rootNode == null ? other$rootNode != null : !this$rootNode.equals(other$rootNode)) {
                return false;
            }
            String this$node = this.getNode();
            String other$node = other.getNode();
            if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
                return false;
            }
            String this$configKey = this.getConfigKey();
            String other$configKey = other.getConfigKey();
            return !(this$configKey == null ? other$configKey != null : !this$configKey.equals(other$configKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Zookeeper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $zkConnectStr = this.getZkConnectStr();
            result = result * 59 + ($zkConnectStr == null ? 43 : $zkConnectStr.hashCode());
            String $configVersion = this.getConfigVersion();
            result = result * 59 + ($configVersion == null ? 43 : $configVersion.hashCode());
            String $rootNode = this.getRootNode();
            result = result * 59 + ($rootNode == null ? 43 : $rootNode.hashCode());
            String $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            String $configKey = this.getConfigKey();
            result = result * 59 + ($configKey == null ? 43 : $configKey.hashCode());
            return result;
        }

        public String toString() {
            return "DtpProperties.Zookeeper(zkConnectStr=" + this.getZkConnectStr() + ", configVersion=" + this.getConfigVersion() + ", rootNode=" + this.getRootNode() + ", node=" + this.getNode() + ", configKey=" + this.getConfigKey() + ")";
        }
    }

    public static class Apollo {
        private String namespace;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Apollo)) {
                return false;
            }
            Apollo other = (Apollo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Apollo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        public String toString() {
            return "DtpProperties.Apollo(namespace=" + this.getNamespace() + ")";
        }
    }

    public static class Nacos {
        private String dataId;
        private String group;
        private String namespace;

        public String getDataId() {
            return this.dataId;
        }

        public String getGroup() {
            return this.group;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Nacos)) {
                return false;
            }
            Nacos other = (Nacos)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dataId = this.getDataId();
            String other$dataId = other.getDataId();
            if (this$dataId == null ? other$dataId != null : !this$dataId.equals(other$dataId)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Nacos;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dataId = this.getDataId();
            result = result * 59 + ($dataId == null ? 43 : $dataId.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        public String toString() {
            return "DtpProperties.Nacos(dataId=" + this.getDataId() + ", group=" + this.getGroup() + ", namespace=" + this.getNamespace() + ")";
        }
    }
}

