<@pp.dropOutputFile />
<#import "../lib/lib.ftl" as lib/>
<#list dalgen.tables as table>
<@pp.changeOutputFile name = "/${dalgen.tablesPath}/${table.sqlName}.xml" />
<!DOCTYPE table SYSTEM "../config/table-config-1.0.dtd">
<table sqlname="${table.sqlName}" physicalName="${table.physicalName}"<#if table.remark??> remark="${table.remark!}"</#if>>
    <!--  特殊字符说明 &lt;&gt; <> -->
    <!--  升级提醒,升级到1.8.1之后 DAO参数顺序修改了 需要排查多参数的情况 -->

    <!-- baseSql option中 select * 会自动替换为 include -->
    <sql id="Base_Column_List">
        <#list table.columnList as column><#if column_index gt 0>,</#if>${column.sqlName}</#list>
    </sql>

    <!-- baseSql option中 select sf.* 会自动替换为 include -->
    <sql id="Base_SF_Column_List">
        <#list table.columnList as column><#if column_index gt 0>,</#if>sf.${column.sqlName}</#list>
    </sql>

    <operation name="insert" paramtype="object" remark="插入表:${table.sqlName}">
        <#if dalgen.dbType=="MySQL">
        <selectKey resultType="java.lang.Long" keyProperty="id" order="AFTER">
            SELECT
            LAST_INSERT_ID()
        </selectKey>
        </#if>
        <![CDATA[
        INSERT INTO ${table.sqlName}(
        <#list table.columnList as column>
            <#if column_index gt 0>,</#if>${column.sqlName}
        </#list>
        )VALUES(
        <#list table.columnList as column>
            <#if column_index gt 0>,</#if> ${lib.insertVal(column,dalgen)}
        </#list>
        )
        ]]>
    </operation>

<#if table.primaryKeys??>
    <!-- 不推荐使用全 update 有需要自己打开
    <operation name="update" paramtype="object" remark="更新表:${table.sqlName}">
        <![CDATA[
        UPDATE ${table.sqlName}
        SET
        <#assign c_idx = 0>
        <#list table.columnList as column>
            <#if lib.updateIncludeColumn(dalgen,column,table.primaryKeys.columnList)><#assign c_idx = c_idx+1>
            <#if c_idx gt 1>,</#if>${column.sqlName}${lib.space(column.sqlName)} = ${lib.updateVal(column)}
            </#if>
        </#list>
        WHERE
        <#list table.primaryKeys.columnList as column>
            <#if column_index gt 0>AND </#if>${column.sqlName}${lib.space(column.sqlName)} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}
        </#list>
        ]]>
    </operation>
    -->
    <operation name="deleteBy${table.primaryKeys.pkName}"  remark="根据主键删除数据:${table.sqlName}">
        <![CDATA[
        <#if table.neadSoftDelete>
            <#assign deleteColumn = dalgen.config.deleteColumn/>
            <#if !deleteColumn.isNumber>
        <#-- 软删除,无版本 -->
        UPDATE ${table.sqlName}
        SET
            ${deleteColumn.name} = '${deleteColumn.delVal}',
            GMT_MODIFIED = now()
        WHERE
        <#list table.primaryKeys.columnList as column>
            <#if column_index gt 0>AND </#if>${column.sqlName} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}
        </#list>
            </#if>
        <#else>
        <#-- 硬删除 -->
        DELETE FROM ${table.sqlName}
        WHERE
        <#list table.primaryKeys.columnList as column>
            <#if column_index gt 0>AND </#if>${column.sqlName} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}
        </#list>
        </#if>
        ]]>
    </operation>

    <operation name="getBy${table.primaryKeys.pkName}" multiplicity="one" remark="根据主键获取数据:${table.sqlName}">
        SELECT *
        FROM ${table.sqlName}
        WHERE
        <![CDATA[
        <#list table.primaryKeys.columnList as column>
            <#if column_index gt 0>AND </#if>${column.sqlName} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}
        </#list>
        ]]>
    </operation>
</#if>
<#list table.uniqueIndexs as uniqueIndex>

    <!-- 根据唯一约束操作数据 -->
    <operation name="updateBy${uniqueIndex.ukName}" paramtype="object" remark="根据唯一约束${uniqueIndex.ukName}更新表:${table.sqlName}">
        <![CDATA[
        UPDATE ${table.sqlName}
        SET
        <#assign c_idx = 0>
        <#list table.columnList as column>
            <#if lib.updateIncludeUKColumn(dalgen,column,table.primaryKeys!,uniqueIndex.columnList)><#assign c_idx = c_idx+1>
            <#if c_idx gt 1>,</#if>${column.sqlName}${lib.space(column.sqlName)} = ${lib.updateVal(column)}
            </#if>
        </#list>
        WHERE
        <#list uniqueIndex.columnList as column><#assign deleteColumn = dalgen.config.deleteColumn/>
            <#if column_index gt 0>AND </#if><#if deleteColumn.name == column.sqlName>${column.sqlName} = <#if deleteColumn.isNumber>${deleteColumn.defVal}<#else>'${deleteColumn.defVal}'</#if><#else>${column.sqlName}${lib.space(column.sqlName)} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}</#if>
        </#list>
        ]]>
    </operation>

    <operation name="deleteBy${uniqueIndex.ukName}" remark="根据唯一约束${uniqueIndex.ukName}删除数据:${table.sqlName}">
        <![CDATA[
        <#assign deleteColumn = dalgen.config.deleteColumn/>
        <#if table.neadSoftDelete>
            <#if deleteColumn.isNumber>
            <#-- 软删除,有版本 -->
        UPDATE  ${table.sqlName} a
            JOIN
                (SELECT max(${deleteColumn.name})+1 as VSN
                FROM ${table.sqlName}
                WHERE
                <#assign _cnt = 0>
                <#list uniqueIndex.columnList as column>
                    <#if deleteColumn.name != column.sqlName>
                    <#assign _cnt = _cnt+1>
                    <#if _cnt gt 1>AND </#if>${column.sqlName} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}
                    </#if>
                </#list>
                ) b
        SET a.${deleteColumn.name}=b.VSN,GMT_MODIFIED = now()
        WHERE
        <#list uniqueIndex.columnList as column>
            <#if column_index gt 0>AND </#if><#if deleteColumn.name == column.sqlName>${column.sqlName} = ${deleteColumn.defVal}<#else>${column.sqlName}${lib.space(column.sqlName)} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}</#if>
        </#list>
            <#else >
            <#-- 软删除,无版本 -->
        UPDATE ${table.sqlName}
        SET
            ${deleteColumn.name} = '${deleteColumn.delVal}',GMT_MODIFIED = now()
        WHERE
        <#list uniqueIndex.columnList as column>
            <#if column_index gt 0>AND </#if><#if deleteColumn.name == column.sqlName>${column.sqlName} = '${deleteColumn.defVal}'<#else>${column.sqlName}${lib.space(column.sqlName)} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}</#if>
        </#list>
            </#if>
        <#else>
        <#-- 硬删除 -->
        DELETE FROM ${table.sqlName}
        WHERE
        <#list uniqueIndex.columnList as column>
            <#if column_index gt 0>AND </#if>${column.sqlName}${lib.space(column.sqlName)} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}
        </#list>
        </#if>
        ]]>
    </operation>

    <operation name="getBy${uniqueIndex.ukName}" multiplicity="one" remark="根据唯一约束${uniqueIndex.ukName}获取数据:${table.sqlName}">
        SELECT *
        FROM ${table.sqlName}
        WHERE
        <![CDATA[
        <#list uniqueIndex.columnList as column>
            <#if column_index gt 0>AND </#if><#if deleteColumn.name == column.sqlName>${column.sqlName} = <#if deleteColumn.isNumber>${deleteColumn.defVal}<#else>'${deleteColumn.defVal}'</#if><#else>${column.sqlName}${lib.space(column.sqlName)} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}</#if>
        </#list>
            <#if deleteColumn.name??>
            AND ${deleteColumn.name?string} = <#if deleteColumn.isNumber>${deleteColumn.defVal}<#else>'${deleteColumn.defVal}'</#if></#if>
        ]]>
    </operation>
</#list>
<#list table.normalIndexs as normalIndex>
    <#assign deleteColumn = dalgen.config.deleteColumn/>
    <!-- 根据普通索引查询数据 -->
    <operation name="queryBy${normalIndex.idxName}" multiplicity="many" remark="根据普通索引${normalIndex.idxName}获取数据:${table.sqlName}">
        SELECT *
        FROM ${table.sqlName}
        WHERE
        <![CDATA[
        <#list normalIndex.columnList as column>
            <#if column_index gt 0>AND </#if><#if deleteColumn.name == column.sqlName>${column.sqlName} = <#if deleteColumn.isNumber>${deleteColumn.defVal}<#else>'${deleteColumn.defVal}'</#if><#else>${column.sqlName}${lib.space(column.sqlName)} = ${"#"}{${column.javaName},jdbcType=${column.sqlType}}</#if>
        </#list>
        <#if deleteColumn.name??>
            AND ${deleteColumn.name?string} = <#if deleteColumn.isNumber>${deleteColumn.defVal}<#else>'${deleteColumn.defVal}'</#if></#if>
        ]]>
    </operation>
</#list>
</table>
</#list>
