/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.utils;

import cn.dalgen.mybatis.gen.DalgenMojo;
import cn.dalgen.mybatis.gen.utils.CmdUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ConfInit {
    public static final String BASE_PATH = ConfInit.class.getResource("").getPath().replace(CmdUtil.class.getPackage().getName().replace(".", "/") + "/", "");
    private static final String NEED_COPY_CONFIG = "dalgen/config/";
    private static final String NEED_COPY_TEMPLATES = "dalgen/templates/";
    private static DalgenMojo dalgenMojo;

    public static void configInit(DalgenMojo dalgenMojo) throws MojoExecutionException, MojoFailureException {
        ConfInit.dalgenMojo = dalgenMojo;
        try {
            JarFile jarFile = new JarFile(ConfInit.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (StringUtils.startsWithIgnoreCase((String)jarEntry.getName(), (String)NEED_COPY_TEMPLATES)) {
                    ConfInit.copyAndOverWriteFile(jarEntry.getName(), new File(ConfInit.dalgenMojo.getTemplateDirectory().getAbsolutePath() + jarEntry.getName().substring(NEED_COPY_TEMPLATES.length() - 1)));
                    continue;
                }
                if (!StringUtils.startsWithIgnoreCase((String)jarEntry.getName(), (String)NEED_COPY_CONFIG)) continue;
                ConfInit.copyDalgenConfig(jarEntry);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!\u8bf7\u8054\u7cfb\u4f5c\u8005~~~~\u65fa\u65fa:bangis", (Exception)e);
        }
    }

    private static void copyDalgenConfig(JarEntry jarEntry) throws IOException {
        if (!StringUtils.startsWithIgnoreCase((String)jarEntry.getName(), (String)NEED_COPY_CONFIG)) {
            return;
        }
        if (!StringUtils.equalsIgnoreCase((String)jarEntry.getName(), (String)NEED_COPY_CONFIG)) {
            if (StringUtils.equalsIgnoreCase((String)jarEntry.getName(), (String)"dalgen/config/config.xml")) {
                if (!dalgenMojo.getConfig().exists()) {
                    ConfInit.copyAndOverWriteFile(jarEntry.getName(), dalgenMojo.getConfig());
                    System.out.println("\u521d\u59cb\u5316\u5b8c\u6210,\u4e0b\u4e00\u6b65\u5230 dalgen/config/config.xml\u914d\u7f6e\u6570\u636e\u6e90");
                    System.exit(0);
                }
            } else {
                ConfInit.copyAndOverWriteFile(jarEntry.getName(), new File(dalgenMojo.getConfig().getParent() + jarEntry.getName().substring(NEED_COPY_CONFIG.length() - 1)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndOverWriteFile(String soureName, File outFile) throws IOException {
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        if (StringUtils.indexOf((String)soureName, (char)'.') == -1) {
            return;
        }
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(ConfInit.class.getResourceAsStream("/" + soureName), "UTF-8"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
            writer.flush();
        }
        catch (NullPointerException e) {
            System.out.println("======");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

